/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import com.zimbra.cs.mina.MinaServer;
import com.zimbra.cs.mina.MinaStats;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public abstract class MinaCodecFactory
implements ProtocolCodecFactory {
    private final MinaServer server;

    protected MinaCodecFactory(MinaServer server) {
        this.server = server;
    }

    public ProtocolEncoder getEncoder() {
        final MinaStats stats = this.server.getStats();
        return new ProtocolEncoderAdapter(){

            public void encode(IoSession session, Object msg, ProtocolEncoderOutput out) {
                ByteBuffer bb = (ByteBuffer)msg;
                if (stats != null) {
                    stats.sentBytes.addAndGet(bb.remaining());
                }
                out.write(bb);
            }
        };
    }
}

