/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mina;

import com.zimbra.cs.mina.MinaUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class LineBuffer {
    private ByteBuffer buf;
    private boolean complete;

    public LineBuffer() {
    }

    public LineBuffer(int size) {
        this.buf = ByteBuffer.allocate(size);
    }

    public boolean parse(ByteBuffer bb) {
        if (!this.complete) {
            int pos = LineBuffer.indexOf(bb, '\n');
            if (pos >= 0) {
                int len = pos + 1 - bb.position();
                ByteBuffer tmp = bb.slice();
                tmp.limit(len);
                bb.position(pos + 1);
                this.buf = MinaUtil.expand(this.buf, len, len).put(tmp);
                this.buf.flip();
                this.complete = true;
            } else {
                this.buf = MinaUtil.expand(this.buf, bb.remaining()).put(bb);
            }
        }
        return this.complete;
    }

    public boolean matches(String s) {
        return s.length() == this.size() && this.startsWith(s);
    }

    public boolean startsWith(String s) {
        if (s.length() <= this.size()) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == this.buf.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    public int size() {
        return this.complete ? this.buf.limit() : this.buf.position();
    }

    public String toString() {
        return this.toString(this.size());
    }

    public String getLine() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Line not complete");
        }
        int len = this.buf.limit();
        if (len > 0 && this.buf.get(len - 1) == 10) {
            while (--len > 0 && this.buf.get(len - 1) == 13) {
            }
        }
        return this.toString(len);
    }

    public String toString(int len) {
        try {
            return new String(this.buf.array(), this.buf.arrayOffset(), len, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("ASCII charset missing");
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void reset() {
        this.buf.clear();
        this.complete = false;
    }

    public void rewind() {
        this.buf.rewind();
    }

    private static int indexOf(ByteBuffer bb, char c) {
        int limit = bb.limit();
        for (int pos = bb.position(); pos < limit; ++pos) {
            if (bb.get(pos) != c) continue;
            return pos;
        }
        return -1;
    }
}

