/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime.handler;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.convert.AttachmentInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeHandlerManager;
import java.io.IOException;
import java.io.Reader;
import javax.activation.DataSource;
import org.apache.lucene.document.Document;

public class TextPlainHandler
extends MimeHandler {
    private String mContent;

    protected boolean runsExternally() {
        return false;
    }

    public void addFields(Document doc) {
    }

    protected String getContentImpl() throws MimeHandlerException {
        if (this.mContent == null) {
            DataSource source = this.getDataSource();
            String ctype = source.getContentType();
            try {
                Reader reader = Mime.getTextReader(source.getInputStream(), ctype, null);
                this.mContent = ByteUtil.getContent(reader, MimeHandlerManager.getIndexedTextLimit(), true);
            }
            catch (IOException e) {
                throw new MimeHandlerException(e);
            }
        }
        if (this.mContent == null) {
            this.mContent = "";
        }
        return this.mContent;
    }

    public boolean doConversion() {
        return false;
    }

    public String convert(AttachmentInfo doc, String baseURL) {
        throw new IllegalStateException("No need to convert plain text");
    }
}

