/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime.handler;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.HtmlTextExtractor;
import com.zimbra.cs.convert.AttachmentInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeHandlerManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.activation.DataSource;
import org.apache.lucene.document.Document;

public class TextHtmlHandler
extends MimeHandler {
    String mContent;

    protected boolean runsExternally() {
        return false;
    }

    public void addFields(Document doc) throws MimeHandlerException {
        this.getContentImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getContentImpl() throws MimeHandlerException {
        if (this.mContent == null) {
            DataSource source = this.getDataSource();
            InputStream is = null;
            try {
                try {
                    is = source.getInputStream();
                    Reader reader = this.getReader(is, source.getContentType());
                    this.mContent = HtmlTextExtractor.extract(reader, MimeHandlerManager.getIndexedTextLimit());
                }
                catch (Exception e) {
                    throw new MimeHandlerException(e);
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
        }
        if (this.mContent == null) {
            this.mContent = "";
        }
        return this.mContent;
    }

    protected Reader getReader(InputStream is, String ctype) throws IOException {
        return Mime.getTextReader(is, ctype, null);
    }

    public boolean doConversion() {
        return false;
    }

    public String convert(AttachmentInfo doc, String baseURL) {
        throw new UnsupportedOperationException();
    }
}

