/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime.handler;

import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.handler.TextHtmlHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextEnrichedHandler
extends TextHtmlHandler {
    private static Map<String, String> sConversions = new HashMap<String, String>();
    private static Map<String, String> sColors;
    private static Pattern RGB_COLOR_PATTERN;

    protected Reader getReader(InputStream is, String ctype) throws IOException {
        String content = Mime.decodeText(is, ctype, null);
        return new StringReader(TextEnrichedHandler.convertToHTML(content));
    }

    public static String convertToHTML(String content) {
        if (content == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(content.length());
        int last = 0;
        int nofill = 0;
        int length = content.length();
        block8: for (int pos = 0; pos < length; ++pos) {
            int c = content.charAt(pos);
            switch (c) {
                case 13: {
                    continue block8;
                }
                case 10: {
                    sb.append(nofill > 0 || last == c ? "<br/>\n" : " ");
                    break;
                }
                case 32: {
                    if (last == c || last != 160 && pos != length - 1 && content.charAt(pos + 1) == ' ') {
                        sb.append("&nbsp;");
                        c = 160;
                        break;
                    }
                }
                default: {
                    sb.append((char)c);
                    break;
                }
                case 38: {
                    sb.append("&amp;");
                    break;
                }
                case 62: {
                    sb.append("&gt;");
                    break;
                }
                case 60: {
                    int gt = content.indexOf(62, pos);
                    if (gt == -1 || gt - pos > 61) {
                        sb.append("&lt;");
                        break;
                    }
                    if (content.charAt(pos + 1) == '<') {
                        sb.append("&lt;");
                        ++pos;
                        break;
                    }
                    String format = content.substring(pos + 1, gt).toLowerCase();
                    String tag = sConversions.get(format);
                    if (format.equals("nofill")) {
                        ++nofill;
                    } else if (format.equals("/nofill")) {
                        --nofill;
                        nofill = Math.max(nofill, 0);
                    } else if (tag != null) {
                        sb.append(tag);
                    } else if (format.equals("param")) {
                        int end = content.indexOf("</param>", gt);
                        if (end != -1) {
                            gt = end + 7;
                        }
                    } else if (format.equals("color")) {
                        sb.append("<font color=#").append(TextEnrichedHandler.readColorParam(content, gt + 1)).append(">");
                    } else if (format.equals("fontfamily")) {
                        String family = TextEnrichedHandler.readParam(content, gt + 1);
                        sb.append("<font face=\"").append(family == null ? "Times" : TextEnrichedHandler.encodeParam(family)).append("\">");
                    }
                    pos = gt;
                }
            }
            last = c;
        }
        return sb.toString();
    }

    private static String readParam(String content, int pos) {
        int end = content.indexOf("</param>", pos);
        if (content.startsWith("<param>", pos) && end != -1) {
            return content.substring(pos + 7, end);
        }
        return null;
    }

    private static String encodeParam(String param) {
        StringBuilder sb = new StringBuilder(param.length());
        int length = param.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = param.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String readColorParam(String content, int pos) {
        String color = TextEnrichedHandler.readParam(content, pos);
        if (color != null) {
            String triplet = sColors.get(color);
            if (triplet != null) {
                return triplet;
            }
            Matcher matcher = RGB_COLOR_PATTERN.matcher(color);
            if (matcher.matches()) {
                return (matcher.group(1) + matcher.group(2) + matcher.group(3)).toUpperCase();
            }
        }
        return "000000";
    }

    public static void main(String[] args) {
        String test = "<bold>Now</bold> is the time for <italic>all</italic>\ngood men\n<smaller>(and <<women>)</smaller> to\n<ignoreme>come</ignoreme>\n\nto the aid of their\n\n\n<color><param>red</param>beloved</color>\ncountry.\n\nBy the way,\nI think that <paraindent><param>left</param><<smaller>\n</paraindent>should REALLY be called\n\n<paraindent><param>left</param><<tinier></paraindent>\nand that I am always right.\n\n<center>-- the end</center>\n";
        System.out.println(TextEnrichedHandler.convertToHTML(test));
    }

    static {
        sConversions.put("bold", "<b>");
        sConversions.put("/bold", "</b>");
        sConversions.put("italic", "<i>");
        sConversions.put("/italic", "</i>");
        sConversions.put("underline", "<u>");
        sConversions.put("/underline", "</u>");
        sConversions.put("fixed", "<tt>");
        sConversions.put("/fixed", "</tt>");
        sConversions.put("excerpt", "<q>");
        sConversions.put("/excerpt", "</q>");
        sConversions.put("smaller", "<font size=-1>");
        sConversions.put("/smaller", "</font>");
        sConversions.put("bigger", "<font size=+1>");
        sConversions.put("/bigger", "</font>");
        sConversions.put("center", "<div align=center>");
        sConversions.put("/center", "</div>");
        sConversions.put("flushleft", "<div align=left>");
        sConversions.put("/flushleft", "</div>");
        sConversions.put("flushright", "<div align=right>");
        sConversions.put("/flushright", "</div>");
        sConversions.put("flushboth", "<div align=justify>");
        sConversions.put("/flushboth", "</div>");
        sConversions.put("/color", "</font>");
        sConversions.put("/fontfamily", "</font>");
        sColors = new HashMap<String, String>();
        sColors.put("red", "FF0000");
        sColors.put("blue", "0000FF");
        sColors.put("green", "008000");
        sColors.put("yellow", "FFFF00");
        sColors.put("cyan", "00FFFF");
        sColors.put("magenta", "FF00FF");
        sColors.put("black", "000000");
        sColors.put("white", "FFFFFF");
        RGB_COLOR_PATTERN = Pattern.compile("(\\p{XDigit}{2})\\p{XDigit}{2},(\\p{XDigit}{2})\\p{XDigit}{2},(\\p{XDigit}{2})\\p{XDigit}{2}");
    }
}

