/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime.handler;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.convert.AttachmentInfo;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeHandlerManager;
import java.io.InputStream;
import javax.activation.DataSource;
import org.apache.lucene.document.Document;

public class TextCalendarHandler
extends MimeHandler {
    private String mContent;
    private ZCalendar.ZVCalendar miCalendar;
    private static final ZCalendar.ICalTok[] COMPONENT_TYPES = new ZCalendar.ICalTok[]{ZCalendar.ICalTok.VEVENT, ZCalendar.ICalTok.VTODO};

    protected boolean runsExternally() {
        return false;
    }

    public ZCalendar.ZVCalendar getICalendar() throws MimeHandlerException {
        this.analyze();
        return this.miCalendar;
    }

    protected String getContentImpl() throws MimeHandlerException {
        this.analyze();
        return this.mContent;
    }

    private void analyze() throws MimeHandlerException {
        if (this.mContent != null) {
            return;
        }
        DataSource source = this.getDataSource();
        InputStream is = null;
        int maxLength = MimeHandlerManager.getIndexedTextLimit();
        try {
            try {
                String cs;
                is = source.getInputStream();
                String charset = "utf-8";
                String ctStr = source.getContentType();
                if (ctStr != null && (cs = Mime.getCharset(ctStr)) != null) {
                    charset = cs;
                }
                this.miCalendar = ZCalendar.ZCalendarBuilder.build(is, charset);
                this.mContent = "";
                StringBuilder buf = new StringBuilder(1024);
                for (ZCalendar.ICalTok type : COMPONENT_TYPES) {
                    ZCalendar.ZComponent comp = this.miCalendar.getComponent(type);
                    if (comp == null) continue;
                    String content = comp.getPropVal(ZCalendar.ICalTok.DESCRIPTION, "").trim();
                    if (content.equals("")) {
                        content = comp.getPropVal(ZCalendar.ICalTok.SUMMARY, "").trim();
                    }
                    if (content.equals("")) continue;
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    if (buf.length() + content.length() > maxLength) {
                        buf.append(content.substring(0, maxLength - buf.length()));
                        break;
                    }
                    buf.append(content);
                }
                this.mContent = buf.toString();
            }
            catch (Exception e) {
                this.mContent = "";
                ZimbraLog.index.warn((Object)"error reading text/calendar mime part", e);
                throw new MimeHandlerException(e);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    public void addFields(Document doc) {
    }

    public String convert(AttachmentInfo doc, String baseURL) {
        throw new UnsupportedOperationException();
    }

    public boolean doConversion() {
        return false;
    }
}

