/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.MimeDetect;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.util.JMSession;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class UUEncodeConverter
extends MimeVisitor {
    protected boolean visitMultipart(MimeMultipart mmp, MimeVisitor.VisitPhase visitKind) {
        return false;
    }

    protected boolean visitBodyPart(MimeBodyPart bp) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean visitMessage(MimeMessage msg, MimeVisitor.VisitPhase visitKind) throws MessagingException {
        if (visitKind != MimeVisitor.VisitPhase.VISIT_END) {
            return false;
        }
        MimeMultipart mmp = null;
        try {
            long size;
            if (!msg.isMimeType("text/plain")) {
                return false;
            }
            String cte = msg.getHeader("Content-Transfer-Encoding", null);
            if (!(cte == null || (cte = cte.trim().toLowerCase()).equals("7bit") || cte.equals("8bit") || cte.equals("binary"))) {
                return false;
            }
            ArrayList<UUDecodedFile> uufiles = null;
            ByteUtil.PositionInputStream is = null;
            try {
                is = new ByteUtil.PositionInputStream(new BufferedInputStream(msg.getInputStream()));
                int c = is.read();
                while (c != -1) {
                    block23: {
                        long start = is.getPosition() - 1L;
                        if (c == 98 && (c = is.read()) == 101 && (c = is.read()) == 103 && (c = is.read()) == 105 && (c = is.read()) == 110 && ((c = is.read()) == 32 || c == 9) && Character.isDigit(c = is.read()) && Character.isDigit(c = is.read()) && Character.isDigit(c = is.read()) && ((c = is.read()) == 32 || c == 9)) {
                            StringBuilder sb = new StringBuilder();
                            while ((c = is.read()) != 13 && c != 10 && c != -1) {
                                sb.append((char)c);
                            }
                            String filename = FileUtil.trimFilename(sb.toString().trim());
                            if (c != -1 && filename.length() > 0) {
                                boolean bl;
                                if (uufiles == null) {
                                    uufiles = new ArrayList<UUDecodedFile>(3);
                                }
                                try {
                                    uufiles.add(new UUDecodedFile(is, filename, start));
                                    if (uufiles.size() != 1 || this.mCallback == null || this.mCallback.onModification()) break block23;
                                    bl = false;
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                Object var16_19 = null;
                                ByteUtil.closeStream(is);
                                return bl;
                            }
                        }
                    }
                    while (c != 13 && c != 10 && c != -1) {
                        c = is.read();
                    }
                    while (c == 13 || c == 10) {
                        c = is.read();
                    }
                }
                size = is.getPosition();
                Object var16_20 = null;
                ByteUtil.closeStream(is);
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            if (uufiles == null || uufiles.isEmpty()) {
                return false;
            }
            mmp = new MimeMultipart("mixed");
            for (UUDecodedFile uu : uufiles) {
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setHeader("Content-Type", uu.getContentType());
                mbp.setHeader("Content-Disposition", new ContentDisposition("attachment").setParameter("filename", uu.getFilename()).toString());
                mbp.setDataHandler(new DataHandler(uu.getDataSource()));
                mmp.addBodyPart((BodyPart)mbp);
                size -= uu.getEndOffset() - uu.getStartOffset();
            }
            InputStream isOrig = null;
            try {
                isOrig = msg.getInputStream();
                long offset = 0L;
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)size);
                byte[] buffer = new byte[8192];
                for (UUDecodedFile uu : uufiles) {
                    long numRead;
                    for (long count = uu.getStartOffset() - offset; count > 0L && (numRead = (long)isOrig.read(buffer, 0, (int)Math.min(count, 8192L))) >= 0L; count -= numRead) {
                        baos.write(buffer, 0, (int)numRead);
                    }
                    isOrig.skip(uu.getEndOffset() - uu.getStartOffset());
                    offset = uu.getEndOffset();
                }
                ByteUtil.copy(isOrig, true, baos, true);
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(baos.toByteArray(), "text/plain")));
                mmp.addBodyPart((BodyPart)mbp, 0);
                Object var21_29 = null;
                ByteUtil.closeStream(isOrig);
            }
            catch (Throwable throwable) {
                Object var21_30 = null;
                ByteUtil.closeStream(isOrig);
                throw throwable;
            }
        }
        catch (MessagingException e) {
            ZimbraLog.extensions.warn((Object)"exception while uudecoding message part; skipping part", e);
            return false;
        }
        catch (IOException e) {
            ZimbraLog.extensions.warn((Object)"exception while uudecoding message part; skipping part", e);
            return false;
        }
        msg.setContent((Multipart)mmp);
        msg.setHeader("Content-Type", mmp.getContentType() + "; generated=true");
        return true;
    }

    public static void main(String[] args) throws MessagingException, IOException {
        MimeMessage mm = new MimeMessage(JMSession.getSession(), (InputStream)new FileInputStream("c:\\tmp\\uuencode-1"));
        new UUEncodeConverter().accept(mm);
        mm.saveChanges();
        mm.writeTo((OutputStream)new FileOutputStream("c:\\tmp\\decoded-1"));
        mm = new MimeMessage(JMSession.getSession(), (InputStream)new FileInputStream("c:\\tmp\\uuencode-2"));
        new UUEncodeConverter().accept(mm);
        mm.saveChanges();
        mm.writeTo((OutputStream)new FileOutputStream("c:\\tmp\\decoded-2"));
    }

    private static class UUDecodedFile {
        private String mFilename;
        private String mContentType;
        private long mStartOffset;
        private long mEndOffset;
        private byte[] mContent;

        private UUDecodedFile(ByteUtil.PositionInputStream is, String filename, long start) throws IOException {
            this.mFilename = filename;
            this.mStartOffset = start;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int length = -1;
            int bits = 0;
            int acc = 0;
            int c = is.read();
            while (c == 114 || c == 10) {
                c = is.read();
            }
            while (c != -1) {
                if (length == 0 && c == 101) {
                    is.mark(3);
                    if (is.read() == 110 && is.read() == 100) break;
                    is.reset();
                }
                length = c - 32 & 0x3F;
                int decoded = 0;
                while (decoded < length) {
                    c = is.read();
                    if (c == -1) {
                        throw new IOException("unexpected eof during uuencoded attachment");
                    }
                    acc = acc << 6 | c - 32 & 0x3F;
                    if ((bits += 6) < 8) continue;
                    baos.write(acc >> (bits -= 8));
                    acc &= 255 >> 8 - bits;
                    ++decoded;
                }
                while ((c = is.read()) != 13 && c != 10 && c != -1) {
                }
                while (c == 13 || c == 10) {
                    c = is.read();
                }
            }
            this.mContent = baos.toByteArray();
            this.mContentType = MimeDetect.getMimeDetect().detect(this.mFilename, this.mContent);
            if (this.mContentType == null) {
                this.mContentType = "application/octet-stream";
            }
            this.mEndOffset = is.getPosition();
        }

        long getStartOffset() {
            return this.mStartOffset;
        }

        long getEndOffset() {
            return this.mEndOffset;
        }

        byte[] getContent() {
            return this.mContent;
        }

        String getContentType() {
            return this.mContentType;
        }

        String getFilename() {
            return this.mFilename;
        }

        DataSource getDataSource() {
            ByteArrayDataSource bads = new ByteArrayDataSource(this.mContent, "application/octet-stream");
            bads.setName(this.mFilename);
            return bads;
        }
    }
}

