/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.util.Zimbra;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.TNEFMime;
import net.freeutils.tnef.mime.TNEFMimeMessage;

public class TnefConverter
extends MimeVisitor {
    protected boolean visitBodyPart(MimeBodyPart bp) {
        return false;
    }

    protected boolean visitMessage(MimeMessage msg, MimeVisitor.VisitPhase visitKind) throws MessagingException {
        if (visitKind != MimeVisitor.VisitPhase.VISIT_END) {
            return false;
        }
        MimeMultipart multi = null;
        try {
            if (!TNEFUtils.isTNEFMimeType(msg.getContentType())) {
                return false;
            }
            Object content = msg.getContent();
            if (!(content instanceof MimeBodyPart)) {
                return false;
            }
            multi = this.expandTNEF((MimeBodyPart)content);
            if (multi == null) {
                return false;
            }
        }
        catch (MessagingException e) {
            ZimbraLog.extensions.warn((Object)"exception while uudecoding message part; skipping part", e);
            return false;
        }
        catch (IOException e) {
            ZimbraLog.extensions.warn((Object)"exception while uudecoding message part; skipping part", e);
            return false;
        }
        if (this.mCallback != null && !this.mCallback.onModification()) {
            return false;
        }
        msg.setContent((Multipart)multi);
        msg.setHeader("Content-Type", multi.getContentType() + "; generated=true");
        return false;
    }

    protected boolean visitMultipart(MimeMultipart mmp, MimeVisitor.VisitPhase visitKind) throws MessagingException {
        if (visitKind != MimeVisitor.VisitPhase.VISIT_END) {
            return false;
        }
        if ("multipart/alternative".equals(mmp.getContentType())) {
            return false;
        }
        HashMap<Integer, MimeBodyPart> changedParts = null;
        try {
            for (int i = 0; i < mmp.getCount(); ++i) {
                BodyPart bp = mmp.getBodyPart(i);
                if (!(bp instanceof MimeBodyPart) || !TNEFUtils.isTNEFMimeType(bp.getContentType())) continue;
                MimeMultipart multi = null;
                try {
                    multi = this.expandTNEF((MimeBodyPart)bp);
                }
                catch (Exception e) {
                    ZimbraLog.extensions.warn((Object)"exception while decoding TNEF; skipping part", e);
                    continue;
                }
                if (multi == null) continue;
                MimeBodyPart replacement = new MimeBodyPart();
                replacement.setContent((Multipart)multi);
                if (changedParts == null) {
                    changedParts = new HashMap<Integer, MimeBodyPart>();
                }
                changedParts.put(i, replacement);
            }
        }
        catch (MessagingException e) {
            ZimbraLog.extensions.warn((Object)"exception while traversing multipart; skipping", e);
            return false;
        }
        if (changedParts == null || changedParts.isEmpty()) {
            return false;
        }
        if (this.mCallback != null && !this.mCallback.onModification()) {
            return false;
        }
        for (Map.Entry change : changedParts.entrySet()) {
            mmp.removeBodyPart(((Integer)change.getKey()).intValue());
            mmp.addBodyPart((BodyPart)change.getValue(), ((Integer)change.getKey()).intValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MimeMultipart expandTNEF(MimeBodyPart bp) throws MessagingException, IOException {
        TNEFMimeMessage converted;
        block20: {
            RawInputStream rawis;
            File tmpfile;
            block21: {
                if (!TNEFUtils.isTNEFMimeType(bp.getContentType())) {
                    return null;
                }
                converted = null;
                tmpfile = null;
                rawis = null;
                TNEFInputStream tnefis = null;
                try {
                    Object var9_6;
                    try {
                        tmpfile = File.createTempFile("expand", ".tnef", new File(LC.zimbra_tmp_directory.value()));
                        bp.saveFile(tmpfile);
                        rawis = new RawInputStream(tmpfile);
                        tnefis = new TNEFInputStream(rawis);
                        converted = TNEFMime.convert(JMSession.getSession(), tnefis);
                    }
                    catch (OutOfMemoryError e) {
                        Zimbra.halt("Ran out of memory while expanding TNEF attachment", e);
                        var9_6 = null;
                        if (tnefis != null) {
                            tnefis.close();
                        }
                        if (rawis != null) {
                            rawis.close();
                        }
                        if (tmpfile != null) {
                            tmpfile.delete();
                        }
                        break block20;
                    }
                    catch (Throwable t) {
                        ZimbraLog.extensions.warn("TNEF attachment expansion failed: " + t.getLocalizedMessage());
                        MimeMultipart mimeMultipart = null;
                        Object var9_7 = null;
                        if (tnefis != null) {
                            tnefis.close();
                        }
                        if (rawis != null) {
                            rawis.close();
                        }
                        if (tmpfile != null) {
                            tmpfile.delete();
                        }
                        return mimeMultipart;
                    }
                    var9_6 = null;
                    if (tnefis == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (tnefis != null) {
                        tnefis.close();
                    }
                    if (rawis != null) {
                        rawis.close();
                    }
                    if (tmpfile != null) {
                        tmpfile.delete();
                    }
                    throw throwable;
                }
                tnefis.close();
            }
            if (rawis != null) {
                rawis.close();
            }
            if (tmpfile != null) {
                tmpfile.delete();
            }
        }
        MimeMultipart convertedMulti = (MimeMultipart)converted.getContent();
        int i = 0;
        while (true) {
            if (i >= convertedMulti.getCount()) {
                MimeBodyPart convertedPart = new MimeBodyPart();
                convertedPart.setContent((Multipart)convertedMulti);
                MimeMultipart altMulti = new MimeMultipart("alternative");
                altMulti.addBodyPart((BodyPart)bp);
                altMulti.addBodyPart((BodyPart)convertedPart);
                return altMulti;
            }
            BodyPart subpart = convertedMulti.getBodyPart(i);
            if (subpart.getHeader("Content-Disposition") == null) {
                subpart.setHeader("Content-Disposition", "attachment");
            }
            ++i;
        }
    }

    public static void main(String[] args) throws MessagingException, IOException {
        MimeMessage mm = new MimeMessage(JMSession.getSession(), (InputStream)new FileInputStream("c:\\tmp\\tnef"));
        new TnefConverter().accept(mm);
        mm.writeTo((OutputStream)new FileOutputStream("c:\\tmp\\decoded-tnef"));
    }
}

