/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.cs.store.Blob;
import java.io.File;
import java.io.IOException;
import javax.mail.internet.MimeMessage;

public class ParsedMessageOptions {
    private MimeMessage mMimeMessage;
    private byte[] mRawData;
    private File mFile;
    private String mRawDigest;
    private Integer mRawSize;
    private Long mReceivedDate;
    private Boolean mIndexAttachments;

    public ParsedMessageOptions() {
    }

    public ParsedMessageOptions(Blob blob, byte[] buffer) throws IOException {
        this(blob, buffer, null, null);
    }

    public ParsedMessageOptions(Blob blob, byte[] buffer, Long receivedDate, Boolean indexAttachments) throws IOException {
        if (buffer == null) {
            this.setContent(blob.getFile());
        } else {
            this.setContent(buffer);
        }
        this.setDigest(blob.getDigest()).setSize(blob.getRawSize());
        if (receivedDate != null) {
            this.setReceivedDate(receivedDate);
        }
        if (indexAttachments != null) {
            this.setAttachmentIndexing(indexAttachments);
        }
    }

    public ParsedMessageOptions setContent(MimeMessage mimeMessage) {
        if (this.mRawData != null || this.mFile != null) {
            throw new IllegalArgumentException("Content can only come from one source.");
        }
        this.mMimeMessage = mimeMessage;
        return this;
    }

    public ParsedMessageOptions setContent(byte[] rawData) {
        if (this.mMimeMessage != null || this.mFile != null) {
            throw new IllegalArgumentException("Content can only come from one source.");
        }
        this.mRawData = rawData;
        return this;
    }

    public ParsedMessageOptions setContent(File file) {
        if (this.mRawData != null || this.mMimeMessage != null) {
            throw new IllegalArgumentException("Content can only come from one source.");
        }
        this.mFile = file;
        return this;
    }

    public ParsedMessageOptions setDigest(String digest) {
        this.mRawDigest = digest;
        return this;
    }

    public ParsedMessageOptions setSize(long size) {
        this.mRawSize = (int)size;
        return this;
    }

    public ParsedMessageOptions setReceivedDate(long receivedDate) {
        this.mReceivedDate = receivedDate;
        return this;
    }

    public ParsedMessageOptions setAttachmentIndexing(boolean enabled) {
        this.mIndexAttachments = enabled;
        return this;
    }

    public MimeMessage getMimeMessage() {
        return this.mMimeMessage;
    }

    public byte[] getRawData() {
        return this.mRawData;
    }

    public File getFile() {
        return this.mFile;
    }

    public String getDigest() {
        return this.mRawDigest;
    }

    public Integer getSize() {
        return this.mRawSize;
    }

    public Long getReceivedDate() {
        return this.mReceivedDate;
    }

    public Boolean getAttachmentIndexing() {
        return this.mIndexAttachments;
    }
}

