/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CalculatorStream;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.convert.ConversionException;
import com.zimbra.cs.index.Fragment;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.ZimbraAnalyzer;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.ExpandMimeMessage;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeHandlerManager;
import com.zimbra.cs.mime.MimeVisitor;
import com.zimbra.cs.mime.ParsedAddress;
import com.zimbra.cs.mime.ParsedMessageOptions;
import com.zimbra.cs.object.ObjectHandlerException;
import com.zimbra.cs.store.BlobInputStream;
import com.zimbra.cs.util.JMSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedMessage {
    private static Log sLog = LogFactory.getLog(ParsedMessage.class);
    private static MailDateFormat sFormat = new MailDateFormat();
    private MimeMessage mMimeMessage;
    private MimeMessage mExpandedMessage;
    private boolean mParsed = false;
    private boolean mAnalyzedBodyParts = false;
    private boolean mAnalyzedNonBodyParts = false;
    private String mBodyContent = "";
    private List<String> mFilenames = new ArrayList<String>();
    private boolean mIndexAttachments;
    private int mNumParseErrors = 0;
    private boolean mTemporaryAnalysisFailure = false;
    private List<MPartInfo> mMessageParts;
    private String mRecipients;
    private String mSender;
    private ParsedAddress mParsedSender;
    private boolean mHasAttachments = false;
    private boolean mHasTextCalendarPart = false;
    private String mFragment = "";
    private long mDateHeader = -1L;
    private long mReceivedDate = -1L;
    private String mSubject;
    private String mNormalizedSubject;
    private boolean mSubjectIsReply;
    private List<IndexDocument> mZDocuments = new ArrayList<IndexDocument>();
    private CalendarPartInfo mCalendarPartInfo;
    private String mRawDigest;
    private boolean mWasMutated;
    private Integer mRawSize;
    private InputStream mSharedStream;
    public static final long DATE_HEADER = -2L;
    public static final long DATE_UNKNOWN = -1L;
    private static final Set<String> SYSTEM_PREFIXES = new HashSet<String>(Arrays.asList("accept:", "accepted:", "decline:", "declined:", "tentative:", "cancelled:", "new time proposed:", "read-receipt:", "share created:", "share accepted:"));
    private static final int MAX_PREFIX_LENGTH = 3;

    public ParsedMessage(MimeMessage msg, boolean indexAttachments) throws ServiceException {
        this(msg, ParsedMessage.getZimbraDateHeader(msg), indexAttachments);
    }

    public ParsedMessage(MimeMessage msg, long receivedDate, boolean indexAttachments) throws ServiceException {
        this.initialize(msg, (Long)receivedDate, indexAttachments, null, null);
    }

    public ParsedMessage(byte[] rawData, boolean indexAttachments) throws ServiceException {
        this(rawData, null, indexAttachments);
    }

    public ParsedMessage(byte[] rawData, Long receivedDate, boolean indexAttachments) throws ServiceException {
        this.initialize(rawData, receivedDate, indexAttachments, null);
    }

    public ParsedMessage(File file, Long receivedDate, boolean indexAttachments) throws ServiceException, IOException {
        this.initialize(file, receivedDate, indexAttachments, null, null);
    }

    public ParsedMessage(ParsedMessageOptions opt) throws ServiceException {
        if (opt.getAttachmentIndexing() == null) {
            throw ServiceException.FAILURE("Options do not specify attachment indexing state.", null);
        }
        if (opt.getMimeMessage() != null) {
            this.initialize(opt.getMimeMessage(), opt.getReceivedDate(), (boolean)opt.getAttachmentIndexing(), opt.getSize(), opt.getDigest());
        } else if (opt.getRawData() != null) {
            this.initialize(opt.getRawData(), opt.getReceivedDate(), opt.getAttachmentIndexing(), opt.getDigest());
        } else if (opt.getFile() != null) {
            try {
                this.initialize(opt.getFile(), opt.getReceivedDate(), (boolean)opt.getAttachmentIndexing(), opt.getSize(), opt.getDigest());
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("Unable to initialize ParsedMessage", e);
            }
        } else {
            throw ServiceException.FAILURE("ParsedMessageOptions do not specify message content", null);
        }
    }

    private void initialize(MimeMessage msg, Long receivedDate, boolean indexAttachments, Integer rawSize, String rawDigest) throws ServiceException {
        this.mMimeMessage = msg;
        this.mExpandedMessage = msg;
        this.mRawSize = rawSize;
        this.mRawDigest = rawDigest;
        this.initialize(receivedDate, indexAttachments);
    }

    private void initialize(byte[] rawData, Long receivedDate, boolean indexAttachments, String rawDigest) throws ServiceException {
        if (rawData == null || rawData.length == 0) {
            throw ServiceException.FAILURE("Message data cannot be null or empty.", null);
        }
        this.mSharedStream = new SharedByteArrayInputStream(rawData);
        this.mRawSize = rawData.length;
        this.mRawDigest = rawDigest;
        this.initialize(receivedDate, indexAttachments);
    }

    private void initialize(File file, Long receivedDate, boolean indexAttachments, Integer rawSize, String rawDigest) throws IOException, ServiceException {
        if (file == null) {
            throw new IOException("File cannot be null.");
        }
        if (file.length() == 0L) {
            throw new IOException("File " + file.getPath() + " is empty.");
        }
        if (rawSize != null) {
            this.mRawSize = rawSize;
        } else if (!FileUtil.isGzipped(file)) {
            this.mRawSize = (int)file.length();
        }
        this.mSharedStream = new BlobInputStream(file, this.mRawSize.intValue());
        this.mRawDigest = rawDigest;
        this.initialize(receivedDate, indexAttachments);
    }

    private void initialize(Long receivedDate, boolean indexAttachments) throws ServiceException {
        try {
            this.init(receivedDate, indexAttachments);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("Unable to initialize ParsedMessage", e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to initialize ParsedMessage", e);
        }
    }

    private void init(Long receivedDate, boolean indexAttachments) throws MessagingException, IOException {
        this.mIndexAttachments = indexAttachments;
        if (this.mMimeMessage == null) {
            if (this.mSharedStream == null) {
                throw new IOException("Content stream has not been initialized.");
            }
            if (!(this.mSharedStream instanceof SharedInputStream)) {
                InputStream in = this.mSharedStream;
                this.mSharedStream = null;
                CalculatorStream calc = new CalculatorStream(in);
                byte[] content = ByteUtil.getContent(calc, 0);
                this.mSharedStream = new SharedByteArrayInputStream(content);
                this.mRawSize = (int)calc.getSize();
                this.mRawDigest = calc.getDigest();
            }
            this.mMimeMessage = this.mExpandedMessage = new Mime.FixedMimeMessage(JMSession.getSession(), this.mSharedStream);
        }
        try {
            this.runMimeMutators();
        }
        catch (Exception e) {
            this.mWasMutated = false;
            this.mMimeMessage = this.mExpandedMessage = new Mime.FixedMimeMessage(JMSession.getSession(), this.getRawInputStream());
        }
        if (this.wasMutated()) {
            this.mRawDigest = null;
            this.mRawSize = null;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.mMimeMessage.writeTo((OutputStream)buffer);
            byte[] content = buffer.toByteArray();
            ByteUtil.closeStream(this.mSharedStream);
            this.mSharedStream = new SharedByteArrayInputStream(content);
            this.mExpandedMessage = null;
            this.mMimeMessage = null;
            this.mMimeMessage = this.mExpandedMessage = new Mime.FixedMimeMessage(JMSession.getSession(), this.mSharedStream);
        }
        ExpandMimeMessage expand = new ExpandMimeMessage(this.mMimeMessage);
        try {
            expand.expand();
            this.mExpandedMessage = expand.getExpanded();
        }
        catch (Exception e) {
            this.mExpandedMessage = this.mMimeMessage;
            sLog.warn((Object)"exception while converting message; message will be analyzed unconverted", e);
        }
        if (receivedDate == null) {
            receivedDate = ParsedMessage.getZimbraDateHeader(this.mMimeMessage);
        }
        this.setReceivedDate(receivedDate);
    }

    public boolean wasMutated() {
        return this.mWasMutated;
    }

    public void setRawDigest(String digest) {
        this.mRawDigest = digest;
    }

    public void setRawSize(Integer size) {
        this.mRawSize = size;
    }

    private ParsedMessage parse() {
        if (this.mParsed) {
            return this;
        }
        this.mParsed = true;
        try {
            this.mMessageParts = Mime.getParts(this.mExpandedMessage);
            this.mHasAttachments = Mime.hasAttachment(this.mMessageParts);
            this.mHasTextCalendarPart = Mime.hasTextCalenndar(this.mMessageParts);
        }
        catch (Exception e) {
            ZimbraLog.index.warn((Object)"exception while parsing message; message will not be indexed", e);
            this.mMessageParts = new ArrayList<MPartInfo>();
        }
        return this;
    }

    private void runMimeMutators() throws MessagingException {
        this.mWasMutated = false;
        for (Class<? extends MimeVisitor> vclass : MimeVisitor.getMutators()) {
            try {
                this.mWasMutated |= vclass.newInstance().accept(this.mMimeMessage);
                if (this.mMimeMessage == this.mExpandedMessage) continue;
                vclass.newInstance().accept(this.mExpandedMessage);
            }
            catch (MessagingException e) {
                throw e;
            }
            catch (Exception e) {
                ZimbraLog.misc.warn((Object)"exception ignored running mutator; skipping", e);
            }
        }
    }

    private void analyzeBodyParts() throws ServiceException {
        if (this.mAnalyzedBodyParts) {
            return;
        }
        this.mAnalyzedBodyParts = true;
        if (DebugConfig.disableMessageAnalysis) {
            return;
        }
        this.parse();
        try {
            Set<MPartInfo> mpiBodies = Mime.getBody(this.mMessageParts, false);
            StringBuilder bodyContent = new StringBuilder();
            for (MPartInfo mpi : this.mMessageParts) {
                String toplevelText;
                boolean isMainBody = mpiBodies.contains(mpi);
                if (!isMainBody || (toplevelText = this.analyzePart(isMainBody, mpi)).length() <= 0) continue;
                ParsedMessage.appendToContent(bodyContent, toplevelText);
            }
            this.mBodyContent = bodyContent.toString().trim();
            this.mFragment = Fragment.getFragment(this.mBodyContent, this.mHasTextCalendarPart);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.warn((Object)"exception while analyzing message; message will be partially indexed", e);
        }
    }

    private void analyzeNonBodyParts() throws ServiceException {
        if (this.mAnalyzedNonBodyParts) {
            return;
        }
        this.mAnalyzedNonBodyParts = true;
        if (DebugConfig.disableMessageAnalysis) {
            return;
        }
        this.analyzeBodyParts();
        try {
            Set<MPartInfo> mpiBodies = Mime.getBody(this.mMessageParts, false);
            StringBuilder fullContent = new StringBuilder(this.mBodyContent);
            for (MPartInfo mpi : this.mMessageParts) {
                String toplevelText;
                boolean isMainBody = mpiBodies.contains(mpi);
                if (isMainBody || (toplevelText = this.analyzePart(isMainBody, mpi)).length() <= 0) continue;
                ParsedMessage.appendToContent(fullContent, toplevelText);
            }
            this.mZDocuments.add(this.setLuceneHeadersFromContainer(this.getMainBodyLuceneDocument(fullContent)));
            this.mBodyContent = "";
            if (this.mNumParseErrors > 0 && sLog.isWarnEnabled()) {
                String msgid = this.getMessageID();
                String sbj = this.getSubject();
                sLog.warn("Message had analysis errors in " + this.mNumParseErrors + " parts (Message-Id: " + msgid + ", Subject: " + sbj + ")");
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.warn((Object)"exception while analyzing message; message will be partially indexed", e);
        }
    }

    public void analyzeFully() throws ServiceException {
        this.analyzeNonBodyParts();
    }

    public MimeMessage getMimeMessage() {
        return this.mExpandedMessage;
    }

    public MimeMessage getOriginalMessage() {
        return this.mMimeMessage;
    }

    public int getRawSize() throws IOException, ServiceException {
        if (this.mRawSize == null) {
            this.initializeDigestAndSize();
        }
        return this.mRawSize;
    }

    public byte[] getRawData() throws IOException {
        int sizeHint = this.mRawSize == null ? 0 : this.mRawSize;
        return ByteUtil.getContent(this.getRawInputStream(), sizeHint);
    }

    public String getRawDigest() throws IOException, ServiceException {
        if (this.mRawDigest == null) {
            this.initializeDigestAndSize();
        }
        return this.mRawDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDigestAndSize() throws IOException, ServiceException {
        MessageDigest digest;
        if (this.mRawDigest != null && this.mRawSize != null) {
            return;
        }
        int size = 0;
        InputStream in = null;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw ServiceException.FAILURE("Unable to calculate digest", e);
        }
        try {
            in = this.getRawInputStream();
            DigestInputStream digestStream = new DigestInputStream(in, digest);
            int numRead = -1;
            byte[] buf = new byte[1024];
            while ((numRead = digestStream.read(buf)) >= 0) {
                size += numRead;
            }
            this.mRawSize = size;
            this.mRawDigest = ByteUtil.encodeFSSafeBase64(digest.digest());
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
    }

    public InputStream getRawInputStream() throws IOException {
        if (this.mSharedStream != null) {
            return ((SharedInputStream)this.mSharedStream).newStream(0L, -1L);
        }
        return Mime.getInputStream(this.mMimeMessage);
    }

    public boolean isAttachmentIndexingEnabled() {
        return this.mIndexAttachments;
    }

    public List<MPartInfo> getMessageParts() {
        this.parse();
        return this.mMessageParts;
    }

    public boolean hasAttachments() {
        this.parse();
        return this.mHasAttachments;
    }

    public BlobInputStream getBlobInputStream() {
        if (this.mSharedStream instanceof BlobInputStream) {
            return (BlobInputStream)this.mSharedStream;
        }
        return null;
    }

    public boolean isStreamedFromDisk() {
        return this.getBlobInputStream() != null;
    }

    public int getPriorityBitmask() {
        this.parse();
        try {
            String xprio = this.getMimeMessage().getHeader("X-Priority", null);
            if (xprio != null) {
                if ((xprio = xprio.trim()).startsWith("1") || xprio.startsWith("2")) {
                    return Flag.BITMASK_HIGH_PRIORITY;
                }
                if (xprio.startsWith("3")) {
                    return 0;
                }
                if (xprio.startsWith("4") || xprio.startsWith("5")) {
                    return Flag.BITMASK_LOW_PRIORITY;
                }
            }
        }
        catch (MessagingException me) {
            // empty catch block
        }
        try {
            String impt = this.getMimeMessage().getHeader("Importance", null);
            if (impt != null) {
                if ((impt = impt.trim().toLowerCase()).startsWith("high")) {
                    return Flag.BITMASK_HIGH_PRIORITY;
                }
                if (impt.startsWith("normal")) {
                    return 0;
                }
                if (impt.startsWith("low")) {
                    return Flag.BITMASK_LOW_PRIORITY;
                }
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return 0;
    }

    public boolean isReply() {
        this.normalizeSubject();
        return this.mSubjectIsReply;
    }

    public String getSubject() {
        this.normalizeSubject();
        return this.mSubject;
    }

    public String getNormalizedSubject() {
        this.normalizeSubject();
        return this.mNormalizedSubject;
    }

    public String getFragment() {
        try {
            this.analyzeBodyParts();
        }
        catch (ServiceException e) {
            sLog.warn((Object)("Message analysis failed when getting fragment; fragment is: " + this.mFragment), e);
        }
        return this.mFragment;
    }

    public String getMessageID() {
        return Mime.getMessageID(this.getMimeMessage());
    }

    public String getRecipients() {
        if (this.mRecipients == null) {
            String recipients = null;
            try {
                recipients = this.getMimeMessage().getHeader("To", ", ");
            }
            catch (MessagingException e) {
                // empty catch block
            }
            if (recipients == null) {
                recipients = "";
            }
            try {
                this.mRecipients = MimeUtility.decodeText((String)recipients);
            }
            catch (UnsupportedEncodingException e1) {
                this.mRecipients = recipients;
            }
        }
        return this.mRecipients;
    }

    public String getSender() {
        if (this.mSender == null) {
            this.mSender = Mime.getSender(this.getMimeMessage());
        }
        return this.mSender;
    }

    public String getSenderEmail() {
        return this.getSenderEmail(true);
    }

    public String getSenderEmail(boolean fromFirst) {
        try {
            if (fromFirst) {
                Address[] froms = this.getMimeMessage().getFrom();
                if (froms != null && froms.length > 0 && froms[0] instanceof InternetAddress) {
                    return ((InternetAddress)froms[0]).getAddress();
                }
                Address sender = this.getMimeMessage().getSender();
                if (sender instanceof InternetAddress) {
                    return ((InternetAddress)sender).getAddress();
                }
            } else {
                Address sender = this.getMimeMessage().getSender();
                if (sender instanceof InternetAddress) {
                    return ((InternetAddress)sender).getAddress();
                }
                Address[] froms = this.getMimeMessage().getFrom();
                if (froms != null && froms.length > 0 && froms[0] instanceof InternetAddress) {
                    return ((InternetAddress)froms[0]).getAddress();
                }
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    public ParsedAddress getParsedSender() {
        if (this.mParsedSender == null) {
            this.mParsedSender = new ParsedAddress(this.getSender()).parse();
        }
        return this.mParsedSender;
    }

    public String getReplyTo() {
        String sender = this.getSender();
        String replyTo = null;
        try {
            replyTo = this.getMimeMessage().getHeader("Reply-To", null);
            if (replyTo == null || replyTo.trim().equals("")) {
                return null;
            }
            replyTo = MimeUtility.decodeText((String)replyTo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sender != null && sender.equals(replyTo)) {
            return null;
        }
        return replyTo;
    }

    public long getDateHeader() {
        if (this.mDateHeader != -1L) {
            return this.mDateHeader;
        }
        this.mDateHeader = this.getReceivedDate();
        try {
            Date dateHeader = this.getMimeMessage().getSentDate();
            if (dateHeader != null) {
                this.mDateHeader = Math.max(dateHeader.getTime(), 0L);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return this.mDateHeader;
    }

    public void setReceivedDate(long date) {
        if (date == -2L) {
            this.mReceivedDate = this.getDateHeader();
        } else if (date != -1L) {
            this.mReceivedDate = Math.max(0L, date) / 1000L * 1000L;
        }
    }

    public long getReceivedDate() {
        if (this.mReceivedDate == -1L) {
            this.mReceivedDate = System.currentTimeMillis();
        }
        assert (this.mReceivedDate >= 0L);
        return this.mReceivedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getZimbraDateHeader(MimeMessage mm) {
        String zimbraHeader = null;
        try {
            zimbraHeader = mm.getHeader("X-Zimbra-Received", null);
            if (zimbraHeader == null || zimbraHeader.trim().equals("")) {
                return -1L;
            }
        }
        catch (MessagingException mex) {
            return -1L;
        }
        Date zimbraDate = null;
        MailDateFormat mailDateFormat = sFormat;
        synchronized (mailDateFormat) {
            try {
                zimbraDate = sFormat.parse(zimbraHeader);
            }
            catch (ParseException e) {
                return -1L;
            }
        }
        return zimbraDate == null ? -1L : zimbraDate.getTime();
    }

    public List<IndexDocument> getLuceneDocuments() {
        try {
            this.analyzeFully();
        }
        catch (ServiceException e) {
            sLog.warn("message analysis failed when getting lucene documents");
        }
        return this.mZDocuments;
    }

    public CalendarPartInfo getCalendarPartInfo() {
        try {
            this.parse();
            if (this.mHasTextCalendarPart) {
                this.analyzeFully();
            }
        }
        catch (ServiceException e) {
            sLog.warn("Message analysis failed when getting calendar info");
        }
        return this.mCalendarPartInfo;
    }

    public boolean hasTemporaryAnalysisFailure() throws ServiceException {
        this.analyzeFully();
        return this.mTemporaryAnalysisFailure;
    }

    private IndexDocument getMainBodyLuceneDocument(StringBuilder fullContent) throws MessagingException, ServiceException {
        Document document = new Document();
        IndexDocument zd = new IndexDocument(document);
        document.add(new Field("type", "message/rfc822", Field.Store.YES, Field.Index.TOKENIZED));
        document.add(new Field("l.partname", "top", Field.Store.YES, Field.Index.UN_TOKENIZED));
        String toValue = this.setHeaderAsLuceneField(document, "to", "to", Field.Store.NO, Field.Index.TOKENIZED);
        String ccValue = this.setHeaderAsLuceneField(document, "cc", "cc", Field.Store.NO, Field.Index.TOKENIZED);
        this.setHeaderAsLuceneField(document, "x-envelope-from", "env_from", Field.Store.NO, Field.Index.TOKENIZED);
        this.setHeaderAsLuceneField(document, "x-envelope-to", "env_to", Field.Store.NO, Field.Index.TOKENIZED);
        String msgId = Mime.getHeader(this.getMimeMessage(), "message-id");
        if (msgId == null) {
            msgId = "";
        }
        if (msgId.length() > 0) {
            if (msgId.charAt(0) == '<') {
                msgId = msgId.substring(1);
            }
            if (msgId.charAt(msgId.length() - 1) == '>') {
                msgId = msgId.substring(0, msgId.length() - 1);
            }
            if (msgId.length() > 0) {
                document.add(new Field("msg_id", msgId, Field.Store.NO, Field.Index.UN_TOKENIZED));
            }
        }
        StringBuilder fieldText = new StringBuilder();
        Enumeration en = this.getMimeMessage().getAllHeaders();
        while (en.hasMoreElements()) {
            Header h = (Header)en.nextElement();
            String key = h.getName().trim();
            String value = h.getValue();
            value = value != null ? MimeUtility.unfold((String)value).trim() : "";
            if (key.length() <= 0) continue;
            if (value.length() == 0) {
                fieldText.append(key).append(':').append("_blank_").append('\n');
                continue;
            }
            fieldText.append(key).append(':').append(value).append('\n');
        }
        if (fieldText.length() > 0) {
            document.add(new Field("l.field", fieldText.toString(), Field.Store.NO, Field.Index.TOKENIZED));
        }
        String from = this.getSender();
        String subject = this.getSubject();
        String sortFrom = this.getParsedSender().getSortString();
        if (sortFrom == null) {
            sortFrom = "";
        } else if (sortFrom.length() > 128) {
            sortFrom = sortFrom.substring(0, 128);
        }
        document.add(new Field("from", from, Field.Store.NO, Field.Index.TOKENIZED));
        document.add(new Field("subject", subject, Field.Store.NO, Field.Index.TOKENIZED));
        StringBuilder contentPrepend = new StringBuilder(subject);
        ParsedMessage.appendToContent(contentPrepend, ZimbraAnalyzer.getAllTokensConcatenated("from", from));
        ParsedMessage.appendToContent(contentPrepend, ZimbraAnalyzer.getAllTokensConcatenated("to", toValue));
        ParsedMessage.appendToContent(contentPrepend, ZimbraAnalyzer.getAllTokensConcatenated("cc", ccValue));
        for (String fn : this.mFilenames) {
            ParsedMessage.appendToContent(contentPrepend, ZimbraAnalyzer.getAllTokensConcatenated("filename", fn));
            ParsedMessage.appendToContent(contentPrepend, fn);
        }
        String text = contentPrepend.toString() + " " + fullContent.toString();
        document.add(new Field("l.content", text, Field.Store.NO, Field.Index.TOKENIZED));
        try {
            MimeHandler.getObjects(text, document);
        }
        catch (ObjectHandlerException e) {
            String msgid = this.getMessageID();
            String sbj = this.getSubject();
            sLog.warn((Object)("Unable to recognize searchable objects in message (Message-ID: " + msgid + ", Subject: " + sbj + ")"), e);
        }
        Set<String> contentTypes = Mime.getAttachmentList(this.mMessageParts);
        StringBuilder buf = new StringBuilder();
        for (String contentType : contentTypes) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(contentType);
        }
        String attachments = buf.toString();
        attachments = attachments.equals("") ? "none" : attachments + "," + "any";
        document.add(new Field("attachment", attachments, Field.Store.NO, Field.Index.TOKENIZED));
        return zd;
    }

    private String setHeaderAsLuceneField(Document d, String headerName, String fieldName, Field.Store stored, Field.Index indexed) throws MessagingException {
        String value = this.getMimeMessage().getHeader(headerName, null);
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            value = MimeUtility.decodeText((String)value);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        d.add(new Field(fieldName, value, stored, indexed));
        d.add(new Field(fieldName, value, stored, indexed));
        return value;
    }

    private IndexDocument setLuceneHeadersFromContainer(IndexDocument zd) throws MessagingException {
        String from;
        Document d = (Document)zd.getWrappedDocument();
        this.setHeaderAsLuceneField(d, "to", "to", Field.Store.NO, Field.Index.TOKENIZED);
        this.setHeaderAsLuceneField(d, "cc", "cc", Field.Store.NO, Field.Index.TOKENIZED);
        String subject = this.getNormalizedSubject();
        String sortFrom = this.getParsedSender().getSortString();
        if (sortFrom != null && sortFrom.length() > 128) {
            sortFrom = sortFrom.substring(0, 128);
        }
        if ((from = this.getSender()) != null) {
            d.add(new Field("from", from, Field.Store.NO, Field.Index.TOKENIZED));
        }
        if (subject != null) {
            d.add(new Field("subject", subject, Field.Store.NO, Field.Index.TOKENIZED));
        }
        return zd;
    }

    private static boolean isBouncedCalendar(MPartInfo mpi) {
        if ("text/calendar".equals(mpi.getContentType())) {
            MPartInfo parent = mpi;
            while ((parent = parent.getParent()) != null) {
                String ct = parent.getContentType();
                if (!"multipart/report".equals(ct)) continue;
                return true;
            }
        }
        return false;
    }

    private void setCalendarPartInfo(MPartInfo mpi, ZCalendar.ZVCalendar cal) {
        this.mCalendarPartInfo = new CalendarPartInfo();
        this.mCalendarPartInfo.cal = cal;
        this.mCalendarPartInfo.method = cal.getMethod();
        this.mCalendarPartInfo.wasForwarded = false;
        MPartInfo parent = mpi;
        while ((parent = parent.getParent()) != null) {
            String ct = parent.getContentType();
            if (!"message/rfc822".equals(ct)) continue;
            this.mCalendarPartInfo.wasForwarded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String analyzePart(boolean isMainBody, MPartInfo mpi) throws MessagingException, ServiceException {
        boolean ignoreCalendar = this.mCalendarPartInfo == null ? ParsedMessage.isBouncedCalendar(mpi) : true;
        String methodParam = new ContentType(mpi.getMimePart().getContentType()).getParameter("method");
        if (methodParam == null && !LC.calendar_allow_invite_without_method.booleanValue()) {
            ignoreCalendar = true;
        }
        String toRet = "";
        try {
            String ctype = mpi.getContentType();
            if (ctype.startsWith("multipart/")) {
                return toRet;
            }
            MimeHandler handler = MimeHandlerManager.getMimeHandler(ctype, mpi.getFilename());
            assert (handler != null);
            Mime.repairTransferEncoding(mpi.getMimePart());
            if (handler.isIndexingEnabled()) {
                ZCalendar.ZVCalendar cal;
                handler.init(mpi.getMimePart().getDataHandler().getDataSource());
                handler.setPartName(mpi.getPartName());
                handler.setFilename(mpi.getFilename());
                handler.setSize(mpi.getSize());
                if (!ignoreCalendar && this.mCalendarPartInfo == null && (cal = handler.getICalendar()) != null) {
                    this.setCalendarPartInfo(mpi, cal);
                }
                if (isMainBody && (!handler.runsExternally() || this.mIndexAttachments) || this.mIndexAttachments && !DebugConfig.disableIndexingAttachmentsTogether) {
                    toRet = handler.getContent();
                }
                if (this.mIndexAttachments && !DebugConfig.disableIndexingAttachmentsSeparately) {
                    IndexDocument zd = new IndexDocument(handler.getDocument());
                    String fn = handler.getFilename();
                    if (fn != null && fn.length() > 0) {
                        this.mFilenames.add(fn);
                    }
                    if (zd != null) {
                        Document doc = (Document)zd.getWrappedDocument();
                        int partSize = mpi.getMimePart().getSize();
                        doc.add(new Field("l.size", Integer.toString(partSize), Field.Store.YES, Field.Index.NO));
                        this.mZDocuments.add(this.setLuceneHeadersFromContainer(zd));
                    }
                }
            }
            if (ignoreCalendar) return toRet;
            if (this.mCalendarPartInfo != null) return toRet;
            if (!ctype.equals("text/calendar")) return toRet;
            if (handler.isIndexingEnabled()) {
                ZimbraLog.index.warn("TextCalendarHandler not correctly installed");
            }
            InputStream is = null;
            try {
                block19: {
                    try {
                        ZCalendar.ZVCalendar cal;
                        String charset = mpi.getContentTypeParameter("charset");
                        if (charset == null || charset.trim().equals("")) {
                            charset = "us-ascii";
                        }
                        if ((cal = ZCalendar.ZCalendarBuilder.build(is = mpi.getMimePart().getInputStream(), charset)) == null) break block19;
                        this.setCalendarPartInfo(mpi, cal);
                    }
                    catch (IOException ioe) {
                        ZimbraLog.index.warn((Object)"error reading text/calendar mime part", ioe);
                        Object var13_22 = null;
                        ByteUtil.closeStream(is);
                        return toRet;
                    }
                }
                Object var13_21 = null;
                ByteUtil.closeStream(is);
                return toRet;
            }
            catch (Throwable throwable) {
                Object var13_23 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
        }
        catch (MimeHandlerException e) {
            ++this.mNumParseErrors;
            String pn = mpi.getPartName();
            String ctype = mpi.getContentType();
            String msgid = this.getMessageID();
            sLog.warn("Unable to parse part %s (%s, %s) of message with Message-ID %s.", (Object)pn, (Object)mpi.getFilename(), (Object)ctype, (Object)msgid, e);
            if (ConversionException.isTemporaryCauseOf(e)) {
                this.mTemporaryAnalysisFailure = true;
            }
            sLog.warn("Attachment will not be indexed.");
            return toRet;
        }
        catch (ObjectHandlerException e) {
            ++this.mNumParseErrors;
            String pn = mpi.getPartName();
            String ct = mpi.getContentType();
            String msgid = this.getMessageID();
            sLog.warn("Unable to parse part %s (%s, %s) of message with Message-ID %s.  Object will not be indexed.", (Object)pn, (Object)mpi.getFilename(), (Object)ct, (Object)msgid, e);
        }
        return toRet;
    }

    private static final void appendToContent(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(s);
    }

    private static Pair<String, Boolean> trimPrefixes(String subject) {
        if (subject == null || subject.length() == 0) {
            return new Pair<String, Boolean>("", false);
        }
        boolean trimmed = false;
        while (true) {
            String remainder;
            int bclose;
            char c;
            if ((subject = subject.trim()).length() == 0) {
                return new Pair<String, Boolean>(subject, trimmed);
            }
            int tstart = subject.length() - 5;
            if (!(tstart < 0 || subject.charAt(tstart) != '(' || (c = subject.charAt(tstart + 1)) != 'f' && c != 'F' || (c = subject.charAt(tstart + 2)) != 'w' && c != 'W' || (c = subject.charAt(tstart + 3)) != 'd' && c != 'D' || subject.charAt(tstart + 4) != ')')) {
                subject = subject.substring(0, subject.length() - 5).trim();
                trimmed = true;
                continue;
            }
            boolean braced = subject.charAt(0) == '[';
            int colon = subject.indexOf(58);
            if (colon > (braced ? 1 : 0)) {
                String prefix = subject.substring(braced ? 1 : 0, colon + 1);
                boolean matched = true;
                if (!SYSTEM_PREFIXES.contains(prefix.toLowerCase())) {
                    int paren = -1;
                    for (int i = 0; matched && i < prefix.length() - 1; ++i) {
                        c = prefix.charAt(i);
                        if ((c == '(' || c == '[') && i > 0 && paren == -1) {
                            paren = i;
                            continue;
                        }
                        if ((c == ')' || c == ']') && paren != -1) {
                            matched &= i > paren + 1 && i == prefix.length() - 2;
                            continue;
                        }
                        if (!Character.isLetter(c)) {
                            matched &= c >= '0' && c <= '9' && paren != -1;
                            continue;
                        }
                        if (i < 3 && paren == -1) continue;
                        matched = false;
                    }
                }
                if (matched) {
                    subject = braced && subject.endsWith("]") ? subject.substring(colon + 1, subject.length() - 1) : subject.substring(colon + 1);
                    trimmed = true;
                    continue;
                }
            }
            if (!braced || (bclose = subject.indexOf(93)) <= 0 || subject.lastIndexOf(91, bclose) != 0 || (remainder = subject.substring(bclose + 1).trim()).length() <= 0) break;
            subject = remainder;
        }
        return new Pair<String, Boolean>(subject, trimmed);
    }

    private static String compressWhitespace(String value) {
        if (value == null || value.equals("")) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        int last = -1;
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(i);
            if (c <= 32 && (c = 32) == last) continue;
            last = c;
            sb.append((char)last);
        }
        return sb.toString();
    }

    private void normalizeSubject() {
        if (this.mNormalizedSubject != null) {
            return;
        }
        try {
            this.mNormalizedSubject = this.mSubject = Mime.getSubject(this.getMimeMessage());
        }
        catch (MessagingException e) {
            // empty catch block
        }
        if (this.mSubject == null) {
            this.mSubject = "";
            this.mNormalizedSubject = "";
            this.mSubjectIsReply = false;
        } else {
            Pair<String, Boolean> normalized = ParsedMessage.trimPrefixes(StringUtil.stripControlCharacters(this.mSubject));
            this.mNormalizedSubject = ParsedMessage.compressWhitespace(normalized.getFirst());
            this.mSubjectIsReply = normalized.getSecond();
            if (this.mNormalizedSubject.length() > 1024) {
                this.mNormalizedSubject = this.mNormalizedSubject.substring(0, 1024).trim();
            }
        }
    }

    public static String normalize(String subject) {
        if ((subject = ParsedMessage.compressWhitespace(ParsedMessage.trimPrefixes(StringUtil.stripControlCharacters(subject)).getFirst())) != null && subject.length() > 1024) {
            subject = subject.substring(0, 1024).trim();
        }
        return subject;
    }

    public static boolean isReply(String subject) {
        return ParsedMessage.trimPrefixes(subject).getSecond();
    }

    private static void testNormalization(String[] test) {
        String raw = test[0];
        String normalized = test[1];
        String description = test[3];
        boolean isReply = Boolean.parseBoolean(test[2]);
        Pair<String, Boolean> result = ParsedMessage.trimPrefixes(StringUtil.stripControlCharacters(raw));
        String actual = ParsedMessage.compressWhitespace(result.getFirst());
        if (!normalized.equals(actual) || isReply != result.getSecond()) {
            System.out.println("failed test: " + description);
            System.out.println("  raw:      {" + raw + '}');
            System.out.println("  expected: |" + normalized + "| (" + (isReply ? "" : "un") + "trimmed)");
            System.out.println("  actual:   |" + actual + "| (" + (result.getSecond() != false ? "" : "un") + "trimmed)");
        }
        if (!normalized.equals(ParsedMessage.normalize(raw))) {
            System.out.println("error in normalize() for {" + raw + '}');
        }
    }

    public static void main(String[] args) {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"foo", "foo", "false", "normal subject"}, {" foo", "foo", "false", "leading whitespace"}, {"foo\t", "foo", "false", "trailing whitespace"}, {"  foo\t", "foo", "false", "leading and trailing whitespace"}, {"foo  bar", "foo bar", "false", "compressing whitespace"}, {null, "", "false", "missing subject"}, {"", "", "false", "blank subject"}, {"  \t ", "", "false", "nothing but whitespace"}, {"[bar] foo", "foo", "false", "mlist prefix"}, {"[foo]", "[foo]", "false", "only a mlist prefix"}, {"[bar[] foo", "[bar[] foo", "false", "broken mlist prefix"}, {"[bar][baz][foo]", "[foo]", "false", "keep only the last mlist prefix"}, {"re: foo", "foo", "true", "re: prefix"}, {"re:foo", "foo", "true", "no space after re: prefix"}, {"  re: foo", "foo", "true", "re: prefix with leading whitespace"}, {"re: [fwd: [fwd: re: [fwd: babylon]]]", "babylon", "true", "re and [fwd"}, {"Ad: Re: Ad: Re: Ad: x", "x", "true", "alternative prefixes"}, {"[foo] Fwd: [bar] Re: fw: b (fWd)  (fwd)", "b", "true", "mlist prefixes, std prefixes, mixed-case fwd trailers"}, {"[foo] Fwd: [bar] Re: d fw: b (fWd)  (fwd)", "d fw: b", "true", "character mixed in with prefixes, mixed-case fwd trailers"}, {"Fwd: [Imap-protocol] Re: so long, and thanks for all the fish!", "so long, and thanks for all the fish!", "true", "intermixed prefixes"}}) {
            ParsedMessage.testNormalization(test);
        }
    }

    public static class CalendarPartInfo {
        public ZCalendar.ZVCalendar cal;
        public ZCalendar.ICalTok method;
        public boolean wasForwarded;
    }
}

