/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.convert.ConversionException;
import com.zimbra.cs.index.Fragment;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.ZimbraAnalyzer;
import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeHandlerManager;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.StoreManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.FileDataSource;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedDocument {
    private Blob mBlob;
    private int mSize;
    private String mDigest;
    private String mContentType;
    private String mFilename;
    private String mCreator;
    private IndexDocument mZDocument;
    private String mFragment;
    private long mCreatedDate;
    private boolean mTemporaryAnalysisFailure;

    private static Blob saveInputAsBlob(InputStream in) throws ServiceException, IOException {
        return StoreManager.getInstance().storeIncoming(in, 0L, null);
    }

    public ParsedDocument(InputStream in, String filename, String ctype, long createdDate, String creator) throws ServiceException, IOException {
        this(ParsedDocument.saveInputAsBlob(in), filename, ctype, createdDate, creator);
    }

    public ParsedDocument(Blob blob, String filename, String ctype, long createdDate, String creator) throws ServiceException, IOException {
        block11: {
            this.mZDocument = null;
            this.mTemporaryAnalysisFailure = false;
            this.mBlob = blob;
            this.mSize = (int)blob.getRawSize();
            this.mDigest = blob.getDigest();
            this.mContentType = ctype;
            this.mFilename = filename;
            this.mCreatedDate = createdDate;
            this.mCreator = creator;
            try {
                MimeHandler handler = MimeHandlerManager.getMimeHandler(ctype, filename);
                assert (handler != null);
                if (handler.isIndexingEnabled()) {
                    handler.init(new FileDataSource(blob.getFile()));
                }
                handler.setFilename(filename);
                handler.setPartName("top");
                handler.setSize(this.mSize);
                String textContent = "";
                try {
                    textContent = handler.getContent();
                }
                catch (MimeHandlerException e) {
                    if (ConversionException.isTemporaryCauseOf(e)) {
                        ZimbraLog.wiki.warn((Object)"Temporary failure extracting from the document.  (is convertd down?)", e);
                        this.mTemporaryAnalysisFailure = true;
                    }
                    ZimbraLog.index.warn((Object)("Failure indexing wiki document " + filename + ".  Item will be partially indexed"), e);
                }
                this.mFragment = Fragment.getFragment(textContent, Fragment.Source.NOTEBOOK);
                try {
                    this.mZDocument = new IndexDocument(handler.getDocument());
                    Document doc = (Document)this.mZDocument.getWrappedDocument();
                    doc.add(new Field("subject", filename, Field.Store.NO, Field.Index.TOKENIZED));
                    StringBuilder content = new StringBuilder();
                    ParsedDocument.appendToContent(content, filename);
                    ParsedDocument.appendToContent(content, ZimbraAnalyzer.getAllTokensConcatenated("filename", filename));
                    ParsedDocument.appendToContent(content, textContent);
                    doc.add(new Field("l.content", content.toString(), Field.Store.NO, Field.Index.TOKENIZED));
                    doc.add(new Field("from", creator, Field.Store.NO, Field.Index.TOKENIZED));
                    doc.add(new Field("filename", filename, Field.Store.YES, Field.Index.TOKENIZED));
                }
                catch (MimeHandlerException e) {
                    if (ConversionException.isTemporaryCauseOf(e)) {
                        ZimbraLog.wiki.warn((Object)"Temporary failure extracting from the document.  (is convertd down?)", e);
                        this.mTemporaryAnalysisFailure = true;
                        break block11;
                    }
                    ZimbraLog.index.warn((Object)("Failure indexing wiki document " + filename + ".  Item will be partially indexed"), e);
                }
                catch (Exception e) {
                    ZimbraLog.index.warn((Object)("Failure indexing wiki document " + filename + ".  Item will be partially indexed"), e);
                }
            }
            catch (MimeHandlerException mhe) {
                throw ServiceException.FAILURE("cannot create ParsedDocument", mhe);
            }
        }
    }

    private static final void appendToContent(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(s);
    }

    public void setVersion(int v) {
        if (this.mZDocument == null) {
            ZimbraLog.wiki.warn("Can't index document version.  (is convertd down?)");
        } else {
            Document doc = (Document)this.mZDocument.getWrappedDocument();
            doc.add(new Field("l.version", Integer.toString(v), Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public String getDigest() {
        return this.mDigest;
    }

    public Blob getBlob() {
        return this.mBlob;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public IndexDocument getDocument() {
        return this.mZDocument;
    }

    public List<IndexDocument> getDocumentList() {
        if (this.mZDocument == null) {
            return Collections.emptyList();
        }
        ArrayList<IndexDocument> toRet = new ArrayList<IndexDocument>(1);
        toRet.add(this.mZDocument);
        return toRet;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public String getCreator() {
        return this.mCreator;
    }

    public long getCreatedDate() {
        return this.mCreatedDate;
    }

    public boolean hasTemporaryAnalysisFailure() {
        return this.mTemporaryAnalysisFailure;
    }
}

