/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CalculatorStream;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.convert.ConversionException;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.ZimbraAnalyzer;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeHandlerManager;
import com.zimbra.cs.object.ObjectHandlerException;
import com.zimbra.cs.util.JMSession;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedContact {
    private Map<String, String> mFields;
    private List<Contact.Attachment> mAttachments;
    private InputStream mSharedStream;
    private MimeMessage mMimeMessage;
    private String mDigest;
    private long mSize;
    private List<IndexDocument> mZDocuments;
    boolean mHasTemporaryAnalysisFailure = false;

    public ParsedContact(Map<String, ? extends Object> fields) throws ServiceException {
        this.init(fields, null);
    }

    public ParsedContact(Map<String, ? extends Object> fields, byte[] content) throws ServiceException {
        SharedByteArrayInputStream in = null;
        if (content != null) {
            in = new SharedByteArrayInputStream(content);
        }
        this.init(fields, (InputStream)in);
    }

    public ParsedContact(Map<String, String> fields, InputStream in) throws ServiceException {
        this.init(fields, in);
    }

    public ParsedContact(Map<String, ? extends Object> fields, List<Contact.Attachment> attachments) throws ServiceException {
        this.init(fields, null);
        if (attachments != null && !attachments.isEmpty()) {
            try {
                this.mAttachments = attachments;
                this.mMimeMessage = ParsedContact.generateMimeMessage(attachments);
                this.mDigest = ByteUtil.getSHA1Digest(Mime.getInputStream(this.mMimeMessage), true);
                for (Contact.Attachment attach : this.mAttachments) {
                    this.mFields.remove(attach.getName());
                }
                if (fields.isEmpty()) {
                    throw ServiceException.INVALID_REQUEST("contact must have fields", null);
                }
                this.initializeSizeAndDigest();
            }
            catch (MessagingException me) {
                throw MailServiceException.MESSAGE_PARSE_ERROR(me);
            }
            catch (IOException ioe) {
                throw MailServiceException.MESSAGE_PARSE_ERROR(ioe);
            }
        }
    }

    public ParsedContact(Contact con) throws ServiceException {
        this.init(con.getFields(), con.getContentStream());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(Map<String, ? extends Object> fields, InputStream in) throws ServiceException {
        try {
            if (in instanceof SharedInputStream) {
                this.mSharedStream = in;
            } else if (in != null) {
                byte[] content = ByteUtil.getContent(in, 1024);
                this.mSharedStream = new SharedByteArrayInputStream(content);
            }
        }
        catch (IOException e) {
            throw MailServiceException.MESSAGE_PARSE_ERROR(e);
        }
        HashMap<String, String> strMap = new HashMap<String, String>();
        if (fields == null) {
            throw ServiceException.INVALID_REQUEST("contact must have fields", null);
        }
        for (String key : fields.keySet()) {
            Object value = fields.get(key);
            String strValue = null;
            key = StringUtil.stripControlCharacters(key);
            if (value instanceof String[]) {
                try {
                    strValue = Contact.encodeMultiValueAttr((String[])value);
                }
                catch (JSONException e) {
                    ZimbraLog.index.warn((Object)("Error encoding multi valued attribute " + key), e);
                }
            } else if (value instanceof String) {
                strValue = StringUtil.stripControlCharacters((String)value);
            }
            if (key == null || key.trim().equals("") || strValue == null || strValue.equals("")) continue;
            strMap.put(key, strValue);
        }
        if (strMap.isEmpty()) {
            throw ServiceException.INVALID_REQUEST("contact must have fields", null);
        }
        ParsedContact.addNicknameAndTypeIfPDL(strMap);
        this.mFields = strMap;
        InputStream contentStream = null;
        if (this.mSharedStream == null) return;
        try {
            try {
                contentStream = this.getContentStream();
                this.mAttachments = ParsedContact.parseBlob(contentStream);
                for (Contact.Attachment attach : this.mAttachments) {
                    this.mFields.remove(attach.getName());
                }
                if (fields.isEmpty()) {
                    throw ServiceException.INVALID_REQUEST("contact must have fields", null);
                }
                this.initializeSizeAndDigest();
            }
            catch (MessagingException me) {
                throw MailServiceException.MESSAGE_PARSE_ERROR(me);
            }
            catch (IOException ioe) {
                throw MailServiceException.MESSAGE_PARSE_ERROR(ioe);
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            ByteUtil.closeStream(contentStream);
            throw throwable;
        }
        ByteUtil.closeStream(contentStream);
    }

    private void initializeSizeAndDigest() throws IOException {
        CalculatorStream calc = new CalculatorStream(this.getContentStream());
        this.mSize = ByteUtil.getDataLength(calc);
        this.mDigest = calc.getDigest();
    }

    private static MimeMessage generateMimeMessage(List<Contact.Attachment> attachments) throws MessagingException {
        Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession());
        MimeMultipart multi = new MimeMultipart("mixed");
        int part = 1;
        for (Contact.Attachment attach : attachments) {
            ContentDisposition cdisp = new ContentDisposition("attachment");
            cdisp.setParameter("filename", attach.getFilename()).setParameter("field", attach.getName());
            MimeBodyPart bp = new MimeBodyPart();
            bp.addHeader("Content-Disposition", cdisp.toString());
            bp.addHeader("Content-Type", attach.getContentType());
            bp.addHeader("Content-Transfer-Encoding", "8bit");
            bp.setDataHandler(attach.getDataHandler());
            multi.addBodyPart((BodyPart)bp);
            attach.setPartName(Integer.toString(part++));
        }
        mm.setContent((Multipart)multi);
        mm.saveChanges();
        return mm;
    }

    private static List<Contact.Attachment> parseBlob(InputStream in) throws MessagingException, IOException {
        Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession(), in);
        MimeMultipart multi = (MimeMultipart)mm.getContent();
        ArrayList<Contact.Attachment> attachments = new ArrayList<Contact.Attachment>(multi.getCount());
        for (int i = 1; i <= multi.getCount(); ++i) {
            MimeBodyPart bp = (MimeBodyPart)multi.getBodyPart(i - 1);
            ContentDisposition cdisp = new ContentDisposition(bp.getHeader("Content-Disposition", null));
            Contact.Attachment attachment = new Contact.Attachment(bp.getDataHandler(), cdisp.getParameter("field"));
            attachment.setPartName(Integer.toString(i));
            attachments.add(attachment);
        }
        return attachments;
    }

    private static void addNicknameAndTypeIfPDL(Map<String, String> fields) throws ServiceException {
        if (!fields.containsKey("dlist")) {
            return;
        }
        String fileAs = fields.get("fileAs");
        if (fileAs == null) {
            throw ServiceException.INVALID_REQUEST("PDL: no fileAs present", null);
        }
        String fileAsPrefix = "8:";
        if (!fileAs.startsWith(fileAsPrefix) || fileAs.length() <= fileAsPrefix.length()) {
            throw ServiceException.INVALID_REQUEST("PDL: invalidfileAs: " + fileAs, null);
        }
        String nickname = fileAs.substring(fileAsPrefix.length());
        fields.put("nickname", nickname);
        fields.put("type", "group");
    }

    public Map<String, String> getFields() {
        return this.mFields;
    }

    public boolean hasAttachment() {
        return this.mAttachments != null && !this.mAttachments.isEmpty();
    }

    public List<Contact.Attachment> getAttachments() {
        return this.mAttachments;
    }

    public InputStream getContentStream() throws IOException {
        if (this.mSharedStream != null) {
            return ((SharedInputStream)this.mSharedStream).newStream(0L, -1L);
        }
        if (this.mMimeMessage != null) {
            return Mime.getInputStream(this.mMimeMessage);
        }
        return null;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getDigest() {
        return this.mDigest;
    }

    public ParsedContact modify(Map<String, String> fieldDelta, List<Contact.Attachment> attachDelta) throws ServiceException {
        if (attachDelta != null && !attachDelta.isEmpty()) {
            for (Contact.Attachment attachment : attachDelta) {
                fieldDelta.remove(attachment.getName());
                this.removeAttachment(attachment.getName());
                if (this.mAttachments == null) {
                    this.mAttachments = new ArrayList<Contact.Attachment>(attachDelta.size());
                }
                this.mAttachments.add(attachment);
            }
        }
        for (Map.Entry entry : fieldDelta.entrySet()) {
            String name = StringUtil.stripControlCharacters((String)entry.getKey());
            String value = StringUtil.stripControlCharacters((String)entry.getValue());
            if (name == null || name.trim().equals("")) continue;
            this.removeAttachment(name);
            if (value == null || value.equals("")) {
                this.mFields.remove(name);
                continue;
            }
            this.mFields.put(name, value);
        }
        if (this.mFields.isEmpty()) {
            throw ServiceException.INVALID_REQUEST("contact must have fields", null);
        }
        ParsedContact.addNicknameAndTypeIfPDL(this.mFields);
        this.mDigest = null;
        this.mZDocuments = null;
        if (this.mAttachments != null) {
            try {
                this.mMimeMessage = ParsedContact.generateMimeMessage(this.mAttachments);
                ByteUtil.closeStream(this.mSharedStream);
                this.mSharedStream = null;
                this.initializeSizeAndDigest();
            }
            catch (MessagingException me) {
                throw MailServiceException.MESSAGE_PARSE_ERROR(me);
            }
            catch (IOException e) {
                throw MailServiceException.MESSAGE_PARSE_ERROR(e);
            }
        } else {
            ByteUtil.closeStream(this.mSharedStream);
            this.mSharedStream = null;
            this.mMimeMessage = null;
            this.mSize = 0L;
            this.mDigest = null;
        }
        return this;
    }

    private void removeAttachment(String name) {
        if (this.mAttachments == null) {
            return;
        }
        Iterator<Contact.Attachment> it = this.mAttachments.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(name)) continue;
            it.remove();
        }
        if (this.mAttachments.isEmpty()) {
            this.mAttachments = null;
        }
    }

    public ParsedContact analyze(Mailbox mbox) throws ServiceException {
        try {
            this.analyzeContact(mbox.attachmentsIndexingEnabled());
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            ZimbraLog.index.warn((Object)"exception while analyzing contact; attachments will be partially indexed", e);
        }
        return this;
    }

    public boolean hasTemporaryAnalysisFailure() {
        return this.mHasTemporaryAnalysisFailure;
    }

    private void analyzeContact(boolean indexAttachments) throws ServiceException {
        if (this.mZDocuments != null) {
            return;
        }
        this.mZDocuments = new ArrayList<IndexDocument>();
        StringBuilder attachContent = new StringBuilder();
        int numParseErrors = 0;
        ServiceException conversionError = null;
        if (this.mAttachments != null) {
            for (Contact.Attachment attach : this.mAttachments) {
                String ctype;
                String part;
                try {
                    this.analyzeAttachment(attach, attachContent, indexAttachments);
                }
                catch (MimeHandlerException e) {
                    ++numParseErrors;
                    part = attach.getPartName();
                    ctype = attach.getContentType();
                    ZimbraLog.index.warn((Object)("Parse error on attachment " + part + " (" + ctype + ")"), e);
                    if (conversionError != null || !ConversionException.isTemporaryCauseOf(e)) continue;
                    conversionError = ServiceException.FAILURE("failed to analyze part", e.getCause());
                    this.mHasTemporaryAnalysisFailure = true;
                }
                catch (ObjectHandlerException e) {
                    ++numParseErrors;
                    part = attach.getPartName();
                    ctype = attach.getContentType();
                    ZimbraLog.index.warn((Object)("Parse error on attachment " + part + " (" + ctype + ")"), e);
                }
            }
        }
        this.mZDocuments.add(new IndexDocument(this.getPrimaryDocument(attachContent.toString())));
    }

    public List<IndexDocument> getLuceneDocuments(Mailbox mbox) throws ServiceException {
        this.analyze(mbox);
        return this.mZDocuments;
    }

    private void analyzeAttachment(Contact.Attachment attach, StringBuilder contentText, boolean indexAttachments) throws MimeHandlerException, ObjectHandlerException, ServiceException {
        String ctype = attach.getContentType();
        MimeHandler handler = MimeHandlerManager.getMimeHandler(ctype, attach.getFilename());
        assert (handler != null);
        if (handler.isIndexingEnabled()) {
            Document doc;
            handler.init(attach);
            handler.setPartName(attach.getPartName());
            handler.setFilename(attach.getFilename());
            handler.setSize(attach.getSize());
            if (indexAttachments && !DebugConfig.disableIndexingAttachmentsTogether) {
                contentText.append(contentText.length() == 0 ? "" : " ").append(handler.getContent());
            }
            if (indexAttachments && !DebugConfig.disableIndexingAttachmentsSeparately && (doc = handler.getDocument()) != null) {
                doc.add(new Field("l.size", Integer.toString(attach.getSize()), Field.Store.YES, Field.Index.NO));
                this.mZDocuments.add(new IndexDocument(doc));
            }
        }
    }

    private static void appendContactField(StringBuilder sb, ParsedContact contact, String fieldName) {
        String s = contact.getFields().get(fieldName);
        if (s != null) {
            sb.append(s).append(' ');
        }
    }

    private Document getPrimaryDocument(String contentStrIn) throws ServiceException {
        Document doc = new Document();
        StringBuilder fieldText = new StringBuilder();
        StringBuilder contentText = new StringBuilder();
        Map<String, String> m = this.getFields();
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (!Contact.isEmailField(entry.getKey()) && !"fileAs".equalsIgnoreCase(entry.getKey())) {
                contentText.append(entry.getValue()).append(' ');
            }
            String fieldTextToAdd = entry.getKey() + ":" + entry.getValue() + "\n";
            fieldText.append(fieldTextToAdd);
        }
        StringBuilder emailSb = new StringBuilder();
        for (String email : Contact.getEmailAddresses(this.getFields())) {
            emailSb.append(email).append(' ');
        }
        String emailStr = emailSb.toString();
        String emailStrTokens = ZimbraAnalyzer.getAllTokensConcatenated("to", emailStr);
        StringBuilder searchText = new StringBuilder(emailStrTokens).append(' ');
        ParsedContact.appendContactField(searchText, this, "company");
        ParsedContact.appendContactField(searchText, this, "firstName");
        ParsedContact.appendContactField(searchText, this, "lastName");
        ParsedContact.appendContactField(searchText, this, "nickname");
        contentText = new StringBuilder(emailStrTokens).append(' ').append((CharSequence)contentText).append(' ').append(contentStrIn);
        doc.add(new Field("to", emailStr, Field.Store.NO, Field.Index.TOKENIZED));
        doc.add(new Field("from", Contact.getFileAsString(this.mFields), Field.Store.NO, Field.Index.TOKENIZED));
        doc.add(new Field("l.contactData", searchText.toString(), Field.Store.NO, Field.Index.TOKENIZED));
        doc.add(new Field("l.content", contentText.toString(), Field.Store.NO, Field.Index.TOKENIZED));
        doc.add(new Field("l.partname", "CONTACT", Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add(new Field("l.field", fieldText.toString(), Field.Store.NO, Field.Index.TOKENIZED));
        return doc;
    }
}

