/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedAddress
implements Comparable<ParsedAddress> {
    private static String HONORIFIC = "([^,\\.\\s]{2,}\\.\\s+)?";
    private static String INITIAL = "(?:[^,\\s]\\.\\s*)";
    private static String FIRST_NAME = "(" + INITIAL + "{2,}|" + INITIAL + "?[^,\\s]+)";
    private static String MIDDLE_NAME = "[^,(;{\\[]*";
    private static String LAST_NAME = "(\\S+)";
    private static Pattern NAME_SPACE_PATTERN = Pattern.compile(HONORIFIC + FIRST_NAME + "\\s+(.*)");
    private static Pattern COMMA_NAME_PATTERN = Pattern.compile(LAST_NAME + ",\\s*(" + HONORIFIC + FIRST_NAME + MIDDLE_NAME + ")(.*)");
    public String emailPart;
    public String personalPart;
    public String honorific;
    public String firstName;
    public String lastName;
    public String suffix;
    private boolean parsed = false;

    public ParsedAddress(String address) {
        try {
            InternetAddress ia = new InternetAddress(address);
            this.initialize(ia.getAddress(), ia.getPersonal());
        }
        catch (AddressException ae) {
            this.personalPart = address;
        }
    }

    public ParsedAddress(InternetAddress ia) {
        this.initialize(ia.getAddress(), ia.getPersonal());
    }

    public ParsedAddress(String email, String personal) {
        this.initialize(email, personal);
    }

    public ParsedAddress(ParsedAddress node) {
        this.emailPart = node.emailPart;
        this.personalPart = node.personalPart;
        this.honorific = node.honorific;
        this.firstName = node.firstName;
        this.lastName = node.lastName;
        this.suffix = node.suffix;
        this.parsed = node.parsed;
    }

    private void initialize(String email, String personal) {
        this.emailPart = email;
        this.personalPart = personal;
        if ("".equals(this.emailPart)) {
            this.emailPart = null;
        }
        if (this.personalPart != null) {
            this.personalPart = this.personalPart.trim().replaceAll("\\s+", " ");
        }
    }

    public String getSortString() {
        this.parse();
        String sort = this.personalPart != null ? this.personalPart : this.emailPart;
        return sort != null ? sort : "";
    }

    public Map<String, String> getAttributes() {
        this.parse();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.honorific != null) {
            map.put("namePrefix", this.honorific);
        }
        if (this.firstName != null) {
            map.put("firstName", this.firstName);
        }
        if (this.lastName != null) {
            map.put("lastName", this.lastName);
        }
        if (this.personalPart != null) {
            map.put("fullName", this.personalPart);
        }
        if (this.emailPart != null) {
            map.put("email", this.emailPart);
        }
        return map;
    }

    public ParsedAddress parse() {
        int p;
        if (this.parsed) {
            return this;
        }
        if (this.emailPart != null && this.emailPart.equals(this.personalPart)) {
            this.personalPart = null;
        }
        if (this.personalPart != null) {
            if (this.personalPart.indexOf(32) == -1 && this.personalPart.indexOf(44) == -1) {
                this.firstName = this.personalPart;
            } else {
                Matcher m = NAME_SPACE_PATTERN.matcher(this.personalPart);
                if (m.matches()) {
                    this.honorific = m.group(1);
                    this.firstName = m.group(2).trim();
                    this.lastName = m.group(3).trim();
                } else {
                    m = COMMA_NAME_PATTERN.matcher(this.personalPart);
                    if (m.matches()) {
                        this.honorific = m.group(3);
                        this.firstName = m.group(4);
                        this.lastName = m.group(1);
                        this.personalPart = m.group(2).trim() + ' ' + m.group(1);
                        String remainder = m.group(5);
                        if (remainder != null && !remainder.equals("")) {
                            if (!remainder.startsWith(",") && !remainder.startsWith(";")) {
                                this.personalPart = this.personalPart + ' ';
                            }
                            this.personalPart = this.personalPart + remainder;
                        }
                    }
                }
            }
        }
        if (this.emailPart != null && this.firstName == null && (p = this.emailPart.indexOf(64)) != -1) {
            String formatted = this.emailPart.substring(0, p).replace('.', ' ').replace('_', ' ');
            int space = formatted.indexOf(32);
            String string = this.firstName = space == -1 ? formatted : formatted.substring(0, space);
            if (space != -1 && this.personalPart == null) {
                this.personalPart = formatted;
            }
        }
        this.parsed = true;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ParsedAddress)) {
            return false;
        }
        return this.compareTo((ParsedAddress)obj) == 0;
    }

    @Override
    public int compareTo(ParsedAddress pa) {
        if (this.emailPart != null && pa.emailPart != null) {
            return this.emailPart.compareToIgnoreCase(pa.emailPart);
        }
        if (this.emailPart != null && pa.emailPart == null) {
            return 1;
        }
        if (this.emailPart == null && pa.emailPart != null) {
            return -1;
        }
        if (this.personalPart != null && pa.personalPart != null) {
            return this.personalPart.compareToIgnoreCase(pa.personalPart);
        }
        if (this.personalPart != null && pa.personalPart == null) {
            return 1;
        }
        if (this.personalPart == null && pa.personalPart != null) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        if (this.emailPart == null) {
            return this.personalPart;
        }
        if (this.personalPart == null) {
            return this.emailPart;
        }
        return '\"' + this.personalPart + "\" <" + this.emailPart + '>';
    }
}

