/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.TnefConverter;
import com.zimbra.cs.mime.UUEncodeConverter;
import java.util.ArrayList;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MimeVisitor {
    private static List<Class<? extends MimeVisitor>> sMimeConverters = new ArrayList<Class<? extends MimeVisitor>>();
    private static List<Class<? extends MimeVisitor>> sMimeMutators = new ArrayList<Class<? extends MimeVisitor>>();
    protected ModificationCallback mCallback;
    private static final int MAX_VISITOR_DEPTH;

    public static void registerConverter(Class<? extends MimeVisitor> vclass) {
        if (vclass != null) {
            ZimbraLog.lmtp.debug("Registering MIME converter: %s", vclass.getName());
            sMimeConverters.add(vclass);
        }
    }

    public static void unregisterConverter(Class<? extends MimeVisitor> vclass) {
        if (vclass != null) {
            ZimbraLog.lmtp.debug("Unregistering MIME converter: %s", vclass.getName());
            sMimeConverters.remove(vclass);
        }
    }

    public static List<Class<? extends MimeVisitor>> getConverters() {
        return new ArrayList<Class<? extends MimeVisitor>>(sMimeConverters);
    }

    public static boolean anyConvertersRegistered() {
        return !sMimeConverters.isEmpty();
    }

    public static void registerMutator(Class<? extends MimeVisitor> vclass) {
        if (vclass != null) {
            ZimbraLog.lmtp.debug("Registering MIME mutator: %s", vclass.getName());
            sMimeMutators.add(vclass);
        }
    }

    public static void unregisterMutator(Class<? extends MimeVisitor> vclass) {
        if (vclass != null) {
            ZimbraLog.lmtp.debug("Unregistering MIME mutator: %s", vclass.getName());
            sMimeMutators.remove(vclass);
        }
    }

    public static List<Class<? extends MimeVisitor>> getMutators() {
        return new ArrayList<Class<? extends MimeVisitor>>(sMimeMutators);
    }

    public static boolean anyMutatorsRegistered() {
        return !sMimeMutators.isEmpty();
    }

    public MimeVisitor setCallback(ModificationCallback callback) {
        this.mCallback = callback;
        return this;
    }

    public ModificationCallback getCallback() {
        return this.mCallback;
    }

    protected abstract boolean visitMessage(MimeMessage var1, VisitPhase var2) throws MessagingException;

    protected abstract boolean visitMultipart(MimeMultipart var1, VisitPhase var2) throws MessagingException;

    protected abstract boolean visitBodyPart(MimeBodyPart var1) throws MessagingException;

    public final synchronized boolean accept(MimeMessage mm) throws MessagingException {
        return this.accept((MimePart)mm, 0);
    }

    private final synchronized boolean accept(MimePart mp, int depth) throws MessagingException {
        MimeMessage mm;
        MimeMultipart content;
        String ctype;
        boolean isMultipart;
        boolean isMessage;
        if (depth >= MAX_VISITOR_DEPTH) {
            return false;
        }
        boolean modified = false;
        if (mp instanceof MimeMessage) {
            modified |= this.visitMessage((MimeMessage)mp, VisitPhase.VISIT_BEGIN);
        }
        boolean bl = isMessage = !(isMultipart = (ctype = Mime.getContentType(mp)).startsWith("multipart/")) && ctype.equals("message/rfc822");
        if (isMultipart) {
            content = null;
            try {
                content = Mime.getMultipartContent(mp, ctype);
            }
            catch (Exception e) {
                ZimbraLog.extensions.warn((Object)"could not fetch multipart content; skipping", e);
            }
            if (content instanceof MimeMultipart) {
                MimeMultipart multi = content;
                boolean multiModified = false;
                if (this.visitMultipart(multi, VisitPhase.VISIT_BEGIN)) {
                    multiModified = true;
                    modified = true;
                }
                try {
                    for (int i = 0; i < multi.getCount(); ++i) {
                        BodyPart bp = multi.getBodyPart(i);
                        if (bp instanceof MimeBodyPart) {
                            if (!this.accept((MimePart)((MimeBodyPart)bp), depth + 1)) continue;
                            multiModified = true;
                            modified = true;
                            continue;
                        }
                        ZimbraLog.extensions.info("unexpected BodyPart subclass: " + bp.getClass().getName());
                    }
                }
                catch (MessagingException e) {
                    ZimbraLog.extensions.warn((Object)"could not fetch body subpart; skipping remainder", e);
                }
                if (this.visitMultipart(multi, VisitPhase.VISIT_END)) {
                    multiModified = true;
                    modified = true;
                }
                if (multiModified) {
                    mp.setContent((Multipart)multi);
                }
            }
        } else if (isMessage) {
            content = null;
            try {
                content = Mime.getMessageContent(mp);
            }
            catch (Exception e) {
                ZimbraLog.extensions.warn((Object)"could not fetch attached message content; skipping", e);
            }
            if (content != null) {
                modified |= this.accept((MimePart)content, depth + 1);
            }
        } else if (mp instanceof MimeBodyPart) {
            modified |= this.visitBodyPart((MimeBodyPart)mp);
        } else if (!(mp instanceof MimeMessage)) {
            ZimbraLog.extensions.info("unexpected MimePart subclass: " + mp.getClass().getName() + " (ctype='" + ctype + "')");
        }
        if (mp instanceof MimeMessage && (modified |= this.visitMessage(mm = (MimeMessage)mp, VisitPhase.VISIT_END))) {
            mm.saveChanges();
        }
        return modified;
    }

    static {
        try {
            if (LC.zimbra_converter_enabled_uuencode.booleanValue()) {
                MimeVisitor.registerConverter(UUEncodeConverter.class);
            }
        }
        catch (Exception e) {
            ZimbraLog.misc.error((Object)"error loading UUENCODE converter", e);
        }
        try {
            if (LC.zimbra_converter_enabled_tnef.booleanValue()) {
                MimeVisitor.registerConverter(TnefConverter.class);
            }
        }
        catch (Exception e) {
            ZimbraLog.misc.error((Object)"error loading TNEF converter", e);
        }
        MAX_VISITOR_DEPTH = LC.zimbra_converter_depth_max.intValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VisitPhase {
        VISIT_BEGIN,
        VISIT_END;

    }

    public static interface ModificationCallback {
        public boolean onModification();
    }
}

