/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class MimeMessageOutputThread
implements Runnable {
    private PipedOutputStream mOut;
    private MimeMessage mMsg;

    MimeMessageOutputThread(MimeMessage msg, PipedOutputStream out) {
        if (msg == null) {
            throw new NullPointerException("msg cannot be null");
        }
        if (out == null) {
            throw new NullPointerException("out cannot be null");
        }
        this.mMsg = msg;
        this.mOut = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.mMsg.writeTo((OutputStream)this.mOut);
            }
            catch (IOException e) {
                ZimbraLog.misc.warn((Object)"Unable to write MimeMessage to output stream.", e);
                Object var3_2 = null;
                ByteUtil.closeStream(this.mOut);
                return;
            }
            catch (MessagingException e) {
                ZimbraLog.misc.warn((Object)"Unable to write MimeMessage to output stream.", e);
                Object var3_3 = null;
                ByteUtil.closeStream(this.mOut);
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ByteUtil.closeStream(this.mOut);
            throw throwable;
        }
        ByteUtil.closeStream(this.mOut);
    }
}

