/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.extension.ExtensionUtil;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeHandler;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeTypeInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MimeHandlerManager {
    private static Map<String, HandlerInfo> sHandlers = new ConcurrentHashMap<String, HandlerInfo>();
    private static Log sLog = LogFactory.getLog(MimeHandlerManager.class);

    public static MimeHandler getMimeHandler(String mimeType, String filename) throws MimeHandlerException {
        String extension;
        HandlerInfo handlerInfo;
        sLog.debug("Getting MIME handler for type %s, filename '%s'", mimeType, filename);
        MimeHandler handler = null;
        if (!StringUtil.isNullOrEmpty(mimeType)) {
            mimeType = Mime.getContentType(mimeType);
        }
        if ((handlerInfo = sHandlers.get(MimeHandlerManager.getKey(mimeType, extension = FileUtil.getExtension(filename)))) == null) {
            handlerInfo = MimeHandlerManager.loadHandler(mimeType, extension);
            sHandlers.put(MimeHandlerManager.getKey(mimeType, extension), handlerInfo);
        }
        handler = handlerInfo.getInstance();
        sLog.debug("Returning MIME handler: %s", handler.getClass().getName());
        return handler;
    }

    public static int getIndexedTextLimit() {
        int length = 0x100000;
        try {
            Provisioning prov = Provisioning.getInstance();
            Server server = prov.getLocalServer();
            length = server.getIntAttr("zimbraAttachmentsIndexedTextLimit", length);
        }
        catch (ServiceException e) {
            sLog.warn((Object)"Unable to determine maximum indexed content length", e);
        }
        return length;
    }

    private static synchronized HandlerInfo loadHandler(String mimeType, String extension) throws MimeHandlerException {
        sLog.debug("Loading MIME handler for type %s, extension '%s'", mimeType, extension);
        try {
            MimeTypeInfo mt = MimeHandlerManager.lookUpMimeTypeInfo(mimeType, extension);
            if (mt == null || mt.getHandlerClass() == null) {
                List<MimeTypeInfo> mimeTypeList;
                boolean isTextType;
                boolean bl = isTextType = mimeType != null && (mimeType.matches("text/.*") || mimeType.equalsIgnoreCase("message/rfc822"));
                if (isTextType) {
                    sLog.debug("Falling back to %s MIME Handler for type %s", "text/plain", mimeType);
                    mimeTypeList = Provisioning.getInstance().getMimeTypes("text/plain");
                    if (mimeTypeList.size() > 0) {
                        mt = mimeTypeList.get(0);
                    } else {
                        sLog.warn("Unable to load MIME handler for %s", "text/plain");
                    }
                }
                if (mt == null || mt.getHandlerClass() == null) {
                    sLog.debug("Falling back to %s MIME Handler for type %s", "all", mimeType);
                    mimeTypeList = Provisioning.getInstance().getMimeTypes("all");
                    if (mimeTypeList.size() > 0) {
                        mt = mimeTypeList.get(0);
                    } else {
                        throw new MimeHandlerException("Unable to load MIME handler for type all");
                    }
                }
            }
            if (mt.getHandlerClass() == null) {
                String msg = String.format("%s not specified for MIME handler %s.", "zimbraMimeHandlerClass", mt.getDescription());
                throw new MimeHandlerException(msg);
            }
            HandlerInfo handlerInfo = new HandlerInfo();
            String className = mt.getHandlerClass();
            if (className.indexOf(46) == -1) {
                className = "com.zimbra.cs.mime.handler." + className;
            }
            handlerInfo.mClass = ExtensionUtil.loadClass(mt.getExtension(), className);
            handlerInfo.mMimeType = mt;
            handlerInfo.mRealMimeType = mimeType;
            return handlerInfo;
        }
        catch (ServiceException e) {
            String msg = String.format("Unable to load MIME handler for type %s, extension %s.", mimeType, extension);
            throw new MimeHandlerException(msg, e);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Unable to load MIME handler for type %s, extension %s.", mimeType, extension);
            throw new MimeHandlerException(msg, e);
        }
    }

    private static String getKey(String mimeType, String ext) {
        if (mimeType == null) {
            mimeType = "";
        }
        if (ext == null) {
            ext = "";
        }
        return mimeType + "," + ext;
    }

    private static MimeTypeInfo lookUpMimeTypeInfo(String mimeType, String ext) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        List<MimeTypeInfo> mimeTypes = prov.getAllMimeTypes();
        if (mimeTypes.size() == 0) {
            return null;
        }
        MimeTypeInfo retVal = null;
        int maxPriority = Integer.MIN_VALUE;
        for (MimeTypeInfo mti : mimeTypes) {
            if (!MimeHandlerManager.matches(mti, mimeType, ext) || mti.getPriority() <= maxPriority) continue;
            retVal = mti;
            maxPriority = mti.getPriority();
        }
        if (retVal != null && retVal.getHandlerClass() == null) {
            ZimbraLog.mailbox.warn("%s not defined for MIME handler %s", "zimbraMimeHandlerClass", retVal.getDescription());
        }
        return retVal;
    }

    private static boolean matches(MimeTypeInfo mti, String mimeType, String ext) {
        if (mti == null) {
            return false;
        }
        if (mimeType == null) {
            mimeType = "";
        }
        if (ext == null) {
            ext = "";
        }
        mimeType = mimeType.toLowerCase();
        ext = ext.toLowerCase();
        if (mti.getFileExtensions().contains(ext)) {
            return true;
        }
        for (String patternString : mti.getMimeTypes()) {
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(mimeType);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    static class HandlerInfo {
        MimeTypeInfo mMimeType;
        Class<MimeHandler> mClass;
        String mRealMimeType;

        HandlerInfo() {
        }

        public MimeHandler getInstance() throws MimeHandlerException {
            MimeHandler handler;
            try {
                handler = this.mClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MimeHandlerException(e);
            }
            catch (IllegalAccessException e) {
                throw new MimeHandlerException(e);
            }
            handler.setContentType(this.mRealMimeType);
            handler.mMimeTypeInfo = this.mMimeType;
            return handler;
        }
    }
}

