/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.convert.AttachmentInfo;
import com.zimbra.cs.convert.ConversionException;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.MimeHandlerException;
import com.zimbra.cs.mime.MimeTypeInfo;
import com.zimbra.cs.object.ObjectHandler;
import com.zimbra.cs.object.ObjectHandlerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.internet.MimeUtility;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public abstract class MimeHandler {
    public static final String ARCHIVE_SEQUENCE = "archseq";
    public static final String CATCH_ALL_TYPE = "all";
    protected MimeTypeInfo mMimeTypeInfo;
    private String mFilename;
    private DataSource mDataSource;
    private String mContentType;
    private int mSize = -1;
    private String mPartName;
    private boolean mDrainedContent = false;
    private static byte[] sDrainBuffer = new byte[4096];

    protected abstract boolean runsExternally();

    protected String getContentType() {
        return this.mContentType != null ? this.mContentType : "";
    }

    protected void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    public String getDescription() {
        return this.mMimeTypeInfo.getDescription();
    }

    public boolean isIndexingEnabled() {
        return this.mMimeTypeInfo.isIndexingEnabled();
    }

    public void init(DataSource source) {
        this.mDataSource = source;
    }

    void setPartName(String partName) {
        this.mPartName = partName;
    }

    public String getPartName() {
        return this.mPartName;
    }

    void setFilename(String filename) {
        this.mFilename = filename;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public DataSource getDataSource() {
        return this.mDataSource;
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    protected abstract void addFields(Document var1) throws MimeHandlerException;

    public final String getContent() throws MimeHandlerException {
        if (!DebugConfig.disableMimePartExtraction) {
            String toRet = this.getContentImpl();
            if (toRet == null) {
                return "";
            }
            return toRet;
        }
        if (!this.mDrainedContent) {
            InputStream is = null;
            try {
                try {
                    is = this.getDataSource().getInputStream();
                    while (is.read(sDrainBuffer) != -1) {
                    }
                    Object var4_3 = null;
                }
                catch (IOException e) {
                    throw new MimeHandlerException("cannot extract text", e);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
            this.mDrainedContent = true;
        }
        return "";
    }

    protected abstract String getContentImpl() throws MimeHandlerException;

    public ZCalendar.ZVCalendar getICalendar() throws MimeHandlerException {
        return null;
    }

    public abstract String convert(AttachmentInfo var1, String var2) throws IOException, ConversionException;

    public boolean handlesArchive() {
        return false;
    }

    public abstract boolean doConversion();

    public Document getDocument() throws MimeHandlerException, ObjectHandlerException, ServiceException {
        Document doc = new Document();
        doc.add(new Field("type", this.getContentType(), Field.Store.YES, Field.Index.TOKENIZED));
        this.addFields(doc);
        String content = this.getContent();
        doc.add(new Field("l.content", content, Field.Store.NO, Field.Index.TOKENIZED));
        MimeHandler.getObjects(content, doc);
        doc.add(new Field("l.partname", this.mPartName, Field.Store.YES, Field.Index.UN_TOKENIZED));
        String name = this.mDataSource.getName();
        if (name != null) {
            try {
                name = MimeUtility.decodeText((String)name);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            doc.add(new Field("filename", name, Field.Store.YES, Field.Index.TOKENIZED));
        }
        return doc;
    }

    public static void getObjects(String text, Document doc) throws ObjectHandlerException, ServiceException {
        if (DebugConfig.disableObjects) {
            return;
        }
        List objects = ObjectHandler.getObjectHandlers();
        StringBuffer l_objects = new StringBuffer();
        for (ObjectHandler h : objects) {
            if (!h.isIndexingEnabled()) continue;
            ArrayList matchedObjects = new ArrayList();
            h.parse(text, matchedObjects, true);
            if (matchedObjects.isEmpty()) continue;
            if (l_objects.length() > 0) {
                l_objects.append(',');
            }
            l_objects.append(h.getType());
        }
        if (l_objects.length() > 0) {
            doc.add(new Field("has", l_objects.toString(), Field.Store.NO, Field.Index.TOKENIZED));
        }
    }

    public AttachmentInfo getDocInfoFromArchive(AttachmentInfo archiveDocInfo, String seq) throws IOException {
        return null;
    }
}

