/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeVisitor;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MimeFormatter
extends MimeVisitor {
    private int mIndentLevel = 0;
    private StringBuilder mBuf = new StringBuilder();

    public boolean visitMessage(MimeMessage mm, MimeVisitor.VisitPhase visitPhase) throws MessagingException {
        if (visitPhase == MimeVisitor.VisitPhase.VISIT_BEGIN) {
            this.indent();
            this.mBuf.append("Message: " + Mime.getSubject(mm) + "\n");
            ++this.mIndentLevel;
        } else {
            --this.mIndentLevel;
        }
        return false;
    }

    public boolean visitMultipart(MimeMultipart mp, MimeVisitor.VisitPhase visitPhase) {
        if (visitPhase == MimeVisitor.VisitPhase.VISIT_BEGIN) {
            this.indent();
            this.mBuf.append("Multipart:\n");
            ++this.mIndentLevel;
        } else {
            --this.mIndentLevel;
        }
        return false;
    }

    public boolean visitBodyPart(MimeBodyPart bp) throws MessagingException {
        this.indent();
        this.mBuf.append("Part: type=" + bp.getContentType() + ", filename=" + bp.getFileName() + "\n");
        if (bp.getContentType().startsWith("text")) {
            this.mBuf.append("----------\n");
            try {
                this.mBuf.append(bp.getContent());
            }
            catch (IOException e) {
                this.mBuf.append(e + "\n");
            }
            this.mBuf.append("----------\n");
        }
        return false;
    }

    private void indent() {
        for (int i = 0; i < this.mIndentLevel; ++i) {
            this.mBuf.append("  ");
        }
    }

    public String toString() {
        return this.mBuf.toString();
    }
}

