/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.MimeCompoundHeader;
import com.zimbra.common.mime.MimeHeader;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.MimeMessageOutputThread;
import com.zimbra.cs.util.JMSession;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.QCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mime {
    static Log sLog = LogFactory.getLog(Mime.class);
    private static final int MAX_DECODE_BUFFER = 2048;
    private static final Set<String> TRANSFER_ENCODINGS = new HashSet<String>(Arrays.asList("7bit", "8bit", "binary", "quoted-printable", "base64"));
    private static final Set<String> INLINEABLE_TYPES = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/gif"));
    private static final int MAX_PREAMBLE_LENGTH = 1024;
    private static final InternetAddress[] NO_ADDRESSES = new InternetAddress[0];
    static Message.RecipientType[] sRcptTypes = new Message.RecipientType[]{Message.RecipientType.TO, Message.RecipientType.CC, Message.RecipientType.BCC};
    private static boolean SUPPORTS_CP1252 = Charset.isSupported("windows-1252");
    private static boolean SUPPORTS_GBK = Charset.isSupported("gbk");
    private static final boolean DEFAULT_CP1252 = SUPPORTS_CP1252 && Charset.defaultCharset().name().equals("iso-8859-1");
    private static final boolean DEFAULT_GBK = SUPPORTS_GBK && Charset.defaultCharset().name().equals("euc_cn");
    private static final String[] NO_HEADERS = new String[0];
    private static Set<String> TEXT_ALTERNATES = new HashSet<String>(Arrays.asList("text/enriched", "text/html"));
    private static Set<String> HTML_ALTERNATES = new HashSet<String>(Arrays.asList("text/enriched", "text/plain"));
    private static Set<String> KNOWN_MULTIPART_TYPES = new HashSet<String>(Arrays.asList("multipart/alternative", "multipart/digest", "multipart/mixed", "multipart/report", "multipart/related", "multipart/signed", "multipart/encrypted"));

    public static List<MPartInfo> getParts(MimeMessage mm) throws IOException, MessagingException {
        List<MPartInfo> parts = Mime.listParts((MimePart)mm);
        Set<MPartInfo> bodies = Mime.getBody(parts, true);
        for (MPartInfo mpi : parts) {
            mpi.mIsFilterableAttachment = Mime.isFilterableAttachment(mpi, bodies);
            if (!mpi.mIsFilterableAttachment || mpi.getContentType().equals("xml/x-zimbra-share")) continue;
            mpi.mIsToplevelAttachment = bodies == null || !bodies.contains(mpi) || !INLINEABLE_TYPES.contains(mpi.mContentType);
        }
        return parts;
    }

    private static List<MPartInfo> listParts(MimePart root) throws MessagingException, IOException {
        ArrayList<MPartInfo> parts = new ArrayList<MPartInfo>();
        LinkedList<MPartInfo> queue = new LinkedList<MPartInfo>();
        queue.add(Mime.generateMPartInfo(root, null, "", 0));
        while (!queue.isEmpty()) {
            MimeMessage mm;
            boolean isMessage;
            MPartInfo mpart = (MPartInfo)queue.removeFirst();
            MimePart mp = mpart.getMimePart();
            parts.add(mpart);
            String cts = mpart.mContentType;
            boolean isMultipart = cts.startsWith("multipart/");
            boolean bl = isMessage = !isMultipart && cts.equals("message/rfc822");
            if (isMultipart) {
                MimeMultipart content;
                String prefix;
                String string = prefix = mpart.mPartName.length() > 0 ? mpart.mPartName + '.' : "";
                if (mp instanceof MimeMessage) {
                    mpart.mPartName = prefix + "TEXT";
                }
                if (!((content = Mime.getMultipartContent(mp, cts)) instanceof MimeMultipart)) continue;
                MimeMultipart multi = content;
                mpart.mChildren = new ArrayList<MPartInfo>(multi.getCount());
                for (int i = 1; i <= multi.getCount(); ++i) {
                    mpart.mChildren.add(Mime.generateMPartInfo((MimePart)multi.getBodyPart(i - 1), mpart, prefix + i, i));
                }
                queue.addAll(0, mpart.mChildren);
                continue;
            }
            if (!isMessage || (mm = Mime.getMessageContent(mp)) == null) continue;
            MPartInfo child = Mime.generateMPartInfo((MimePart)mm, mpart, mpart.mPartName, 0);
            queue.addFirst(child);
            mpart.mChildren = Arrays.asList(child);
        }
        return parts;
    }

    private static MPartInfo generateMPartInfo(MimePart mp, MPartInfo parent, String prefix, int partNum) {
        boolean inDigest = parent != null && parent.mContentType.equals("multipart/digest");
        String ctdefault = inDigest ? "message/rfc822" : "text/plain";
        String cts = Mime.getContentType(mp, ctdefault);
        String disp = null;
        String filename = Mime.getFilename(mp);
        int size = 0;
        try {
            disp = mp.getDisposition();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            size = mp.getSize();
        }
        catch (MessagingException me) {
            // empty catch block
        }
        boolean isMultipart = cts.startsWith("multipart/");
        if (!isMultipart && mp instanceof MimeMessage) {
            prefix = (prefix.length() > 0 ? prefix + "." : "") + '1';
        }
        MPartInfo mpart = new MPartInfo();
        mpart.mPart = mp;
        mpart.mParent = parent;
        mpart.mContentType = cts;
        mpart.mPartName = prefix;
        mpart.mPartNum = partNum;
        mpart.mSize = size;
        mpart.mChildren = null;
        mpart.mDisposition = disp == null ? (inDigest && cts.equals("message/rfc822") ? "attachment" : "") : disp.toLowerCase();
        mpart.mFilename = filename == null ? "" : filename.toLowerCase();
        return mpart;
    }

    private static MimeMultipart validateMultipart(MimeMultipart multi, MimePart mp) throws MessagingException, IOException {
        ContentType ctype = new ContentType(mp.getContentType());
        try {
            if (!ctype.containsParameter("generated") && !Mime.findStartBoundary(mp, ctype.getParameter("boundary"))) {
                return new MimeMultipart((DataSource)new RawContentMultipartDataSource(mp, ctype));
            }
            multi.getCount();
        }
        catch (ParseException pe) {
            multi = new MimeMultipart((DataSource)new FixedMultipartDataSource(mp, ctype));
        }
        catch (MessagingException me) {
            multi = new MimeMultipart((DataSource)new FixedMultipartDataSource(mp, ctype));
        }
        return multi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean findStartBoundary(MimePart mp, String boundary) throws IOException {
        InputStream is;
        block15: {
            boolean bl;
            block14: {
                boolean bl2;
                block13: {
                    is = null;
                    try {
                        is = Mime.getRawInputStream(mp);
                    }
                    catch (MessagingException me) {
                        return true;
                    }
                    int blength = boundary == null ? 0 : boundary.length();
                    int bindex = 0;
                    int dashes = 0;
                    boolean failed = false;
                    try {
                        for (int i = 0; i < 1024; ++i) {
                            int c = is.read();
                            if (c == -1) {
                                bl2 = false;
                                Object var11_12 = null;
                                break block13;
                            }
                            if (c == 13 || c == 10) {
                                if (!failed && (boundary == null ? bindex > 0 : bindex == blength)) {
                                    bl = true;
                                    break block14;
                                } else {
                                    dashes = 0;
                                    bindex = 0;
                                    failed = false;
                                    continue;
                                }
                            }
                            if (failed) continue;
                            if (dashes != 2) {
                                if (c == 45) {
                                    ++dashes;
                                    continue;
                                }
                                failed = true;
                                continue;
                            }
                            if (boundary == null) {
                                if (Character.isWhitespace(c)) {
                                    failed = true;
                                }
                                ++bindex;
                                continue;
                            }
                            if (bindex < blength && c == boundary.charAt(bindex++)) continue;
                            failed = true;
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        ByteUtil.closeStream(is);
                        throw throwable;
                    }
                }
                ByteUtil.closeStream(is);
                return bl2;
            }
            Object var11_13 = null;
            ByteUtil.closeStream(is);
            return bl;
        }
        Object var11_14 = null;
        ByteUtil.closeStream(is);
        return false;
    }

    static InputStream getRawInputStream(MimePart mp) throws MessagingException {
        if (mp instanceof MimeBodyPart) {
            return ((MimeBodyPart)mp).getRawInputStream();
        }
        if (mp instanceof MimeMessage) {
            return ((MimeMessage)mp).getRawInputStream();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MimeMessage getMessageContent(MimePart message822Part) throws IOException, MessagingException {
        FixedMimeMessage fixedMimeMessage;
        Object content;
        String ctype = Mime.getContentType(message822Part);
        if ("message/rfc822".equals(ctype) && (content = message822Part.getContent()) instanceof MimeMessage) {
            return (MimeMessage)content;
        }
        InputStream is = null;
        try {
            is = message822Part.getInputStream();
            fixedMimeMessage = new FixedMimeMessage(JMSession.getSession(), is);
            Object var5_5 = null;
        }
        catch (Exception exception) {
            try {
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
            return null;
        }
        ByteUtil.closeStream(is);
        return fixedMimeMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MimeMultipart getMultipartContent(MimePart multipartPart, String contentType) throws IOException, MessagingException {
        MimeMultipart mmp;
        block8: {
            Object content = multipartPart.getContent();
            mmp = null;
            if (content instanceof MimeMultipart) {
                mmp = (MimeMultipart)content;
            } else if (content instanceof InputStream) {
                try {
                    try {
                        mmp = new MimeMultipart((DataSource)new InputStreamDataSource((InputStream)content, contentType));
                    }
                    catch (Exception e) {
                        Object var6_5 = null;
                        ByteUtil.closeStream((InputStream)content);
                        break block8;
                    }
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    ByteUtil.closeStream((InputStream)content);
                    throw throwable;
                }
                ByteUtil.closeStream((InputStream)content);
            }
        }
        if (mmp == null) {
            return null;
        }
        return Mime.validateMultipart(mmp, multipartPart);
    }

    public static String getStringContent(MimePart textPart, String defaultCharset) throws IOException, MessagingException {
        Mime.repairTransferEncoding(textPart);
        return Mime.decodeText(textPart.getInputStream(), textPart.getContentType(), defaultCharset);
    }

    public static Reader getContentAsReader(MimePart textPart, String defaultCharset) throws IOException, MessagingException {
        Mime.repairTransferEncoding(textPart);
        return Mime.getTextReader(textPart.getInputStream(), textPart.getContentType(), defaultCharset);
    }

    public static void repairTransferEncoding(MimePart mp) throws MessagingException {
        String cte = mp.getHeader("Content-Transfer-Encoding", null);
        if (cte != null && !TRANSFER_ENCODINGS.contains(cte.toLowerCase().trim())) {
            mp.removeHeader("Content-Transfer-Encoding");
        }
    }

    public static MimePart getMimePart(MimePart mp, String part) throws IOException, MessagingException {
        if (mp == null) {
            return null;
        }
        if (part == null || part.trim().equals("")) {
            return mp;
        }
        part = part.trim();
        boolean digestParent = false;
        String[] subpart = part.split("\\.");
        for (int i = 0; i < subpart.length; ++i) {
            int index = Integer.parseInt(subpart[i]);
            if (index <= 0) {
                return null;
            }
            String ct = Mime.getContentType(mp, digestParent ? "message/rfc822" : "text/plain");
            if (ct == null) {
                return null;
            }
            digestParent = ct.equals("multipart/digest");
            if (ct.startsWith("multipart/")) {
                BodyPart bp;
                MimeMultipart mmp = Mime.getMultipartContent(mp, ct);
                if (mmp != null && mmp.getCount() >= index && (bp = mmp.getBodyPart(index - 1)) instanceof MimePart) {
                    mp = (MimePart)bp;
                    continue;
                }
            } else {
                MimeMessage content;
                if (mp instanceof MimeMessage && index == 1 && i == subpart.length - 1) break;
                if (ct.equals("message/rfc822") && (content = Mime.getMessageContent(mp)) != null) {
                    if (mp instanceof MimeMessage) {
                        if (index != 1) {
                            return null;
                        }
                    } else {
                        --i;
                    }
                    mp = content;
                    continue;
                }
            }
            return null;
        }
        return mp;
    }

    private static boolean isFilterableAttachment(MPartInfo mpi, Set<MPartInfo> bodies) {
        MPartInfo parent = mpi.getParent();
        String ctype = mpi.getContentType();
        if (ctype.startsWith("multipart/")) {
            return false;
        }
        if (ctype.startsWith("text/")) {
            MPartInfo pp;
            if (parent == null || mpi.getPartNum() == 1 && parent.getContentType().equals("message/rfc822")) {
                return false;
            }
            if (bodies != null && bodies.contains(mpi)) {
                return false;
            }
            if (parent != null && parent.getContentType().equals("multipart/alternative")) {
                return false;
            }
            if (mpi.getPartNum() == 1 && parent != null && parent.getContentType().startsWith("multipart/") && ((pp = parent.getParent()) == null || pp.getContentType().equals("message/rfc822"))) {
                return false;
            }
        }
        return true;
    }

    public static Set<String> getAttachmentList(List<MPartInfo> parts) {
        HashSet<String> set = new HashSet<String>();
        for (MPartInfo mpi : parts) {
            if (!mpi.isFilterableAttachment()) continue;
            set.add(mpi.getContentType());
        }
        return set;
    }

    public static boolean hasAttachment(List<MPartInfo> parts) {
        for (MPartInfo mpi : parts) {
            if (!mpi.mIsToplevelAttachment) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTextCalenndar(List<MPartInfo> parts) {
        for (MPartInfo mpi : parts) {
            if (!"text/calendar".equals(mpi.getContentType())) continue;
            return true;
        }
        return false;
    }

    public static InternetAddress[] parseAddressHeader(String header) {
        return Mime.parseAddressHeader(header, true);
    }

    public static InternetAddress[] parseAddressHeader(MimeMessage mm, String headerName) {
        return Mime.parseAddressHeader(mm, headerName, true);
    }

    public static InternetAddress[] parseAddressHeader(MimeMessage mm, String headerName, boolean expandGroups) {
        try {
            return Mime.parseAddressHeader(mm.getHeader(headerName, ","), expandGroups);
        }
        catch (MessagingException e) {
            return NO_ADDRESSES;
        }
    }

    public static InternetAddress[] parseAddressHeader(String header, boolean expandGroups) {
        InternetAddress[] addresses;
        if (header == null || header.trim().equals("")) {
            return NO_ADDRESSES;
        }
        header = header.trim();
        try {
            addresses = InternetAddress.parseHeader((String)header, (boolean)false);
        }
        catch (AddressException e) {
            try {
                return new InternetAddress[]{new InternetAddress(null, header, "utf-8")};
            }
            catch (UnsupportedEncodingException e1) {
                return NO_ADDRESSES;
            }
        }
        if (!expandGroups) {
            return addresses;
        }
        boolean hasGroups = false;
        for (InternetAddress addr : addresses) {
            if (!addr.isGroup()) continue;
            hasGroups = true;
            break;
        }
        if (!hasGroups) {
            return addresses;
        }
        ArrayList<InternetAddress> expanded = new ArrayList<InternetAddress>();
        for (InternetAddress addr : addresses) {
            if (!addr.isGroup()) {
                expanded.add(addr);
                continue;
            }
            try {
                InternetAddress[] members = addr.getGroup(false);
                if (members == null) {
                    expanded.add(addr);
                    continue;
                }
                for (InternetAddress member : members) {
                    expanded.add(member);
                }
            }
            catch (AddressException e) {
                expanded.add(addr);
            }
        }
        return expanded.toArray(new InternetAddress[expanded.size()]);
    }

    public static void removeRecipients(MimeMessage mm, String[] rcpts) throws MessagingException {
        for (Message.RecipientType rcptType : sRcptTypes) {
            Address[] addrs = mm.getRecipients(rcptType);
            if (addrs == null) continue;
            ArrayList<InternetAddress> list = new ArrayList<InternetAddress>(addrs.length);
            for (int j = 0; j < addrs.length; ++j) {
                InternetAddress inetAddr = (InternetAddress)addrs[j];
                String addr = inetAddr.getAddress();
                boolean match = false;
                for (int k = 0; k < rcpts.length; ++k) {
                    if (!addr.equalsIgnoreCase(rcpts[k])) continue;
                    match = true;
                }
                if (match) continue;
                list.add(inetAddr);
            }
            if (list.size() >= addrs.length) continue;
            InternetAddress[] newRcpts = new InternetAddress[list.size()];
            list.toArray(newRcpts);
            mm.setRecipients(rcptType, (Address[])newRcpts);
        }
    }

    public static final String getContentType(Multipart multi) {
        return Mime.getContentType(multi.getContentType());
    }

    public static final String getContentType(MimePart mp) {
        return Mime.getContentType(mp, "text/plain");
    }

    public static final String getContentType(MimePart mp, String ctdefault) {
        try {
            String cthdr = mp.getHeader("Content-Type", null);
            if (cthdr == null || cthdr.trim().equals("")) {
                return ctdefault;
            }
            return Mime.getContentType(cthdr);
        }
        catch (MessagingException e) {
            ZimbraLog.extensions.warn((Object)"could not fetch part's content-type; defaulting to text/plain", e);
            return "text/plain";
        }
    }

    public static final String getContentType(String cthdr) {
        return new ContentType(cthdr).getValue().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeText(InputStream input, String contentType, String defaultCharset) throws IOException {
        StringBuilder buffer = new StringBuilder();
        try {
            int num;
            Reader reader = Mime.getTextReader(input, contentType, defaultCharset);
            char[] cbuff = new char[2048];
            while ((num = reader.read(cbuff, 0, cbuff.length)) != -1) {
                buffer.append(cbuff, 0, num);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ByteUtil.closeStream(input);
            throw throwable;
        }
        ByteUtil.closeStream(input);
        return buffer.toString();
    }

    public static Reader getTextReader(InputStream input, String contentType, String defaultCharset) {
        Reader reader = null;
        String charset = Mime.getCharset(contentType);
        if (charset != null) {
            charset = charset.toLowerCase();
            if (SUPPORTS_CP1252 && charset.equals("iso-8859-1")) {
                reader = Mime.getReader(input, "windows-1252");
            } else if (SUPPORTS_GBK && (charset.equals("gb2312") || charset.equals("euc_cn"))) {
                reader = Mime.getReader(input, "gbk");
            }
            if (reader == null) {
                reader = Mime.getReader(input, charset);
            }
        }
        if (reader == null && defaultCharset != null && !defaultCharset.trim().equals("")) {
            defaultCharset = defaultCharset.toLowerCase();
            if (SUPPORTS_CP1252 && defaultCharset.equals("iso-8859-1")) {
                reader = Mime.getReader(input, "windows-1252");
            } else if (SUPPORTS_GBK && (defaultCharset.equals("gb2312") || defaultCharset.equals("euc_cn"))) {
                reader = Mime.getReader(input, "gbk");
            }
            if (reader == null) {
                reader = Mime.getReader(input, defaultCharset);
            }
        }
        if (reader == null && DEFAULT_CP1252) {
            reader = Mime.getReader(input, "windows-1252");
        } else if (reader == null && DEFAULT_GBK) {
            reader = Mime.getReader(input, "gbk");
        }
        if (reader == null) {
            reader = new InputStreamReader(input);
        }
        return reader;
    }

    private static Reader getReader(InputStream is, String charset) {
        try {
            return new InputStreamReader(is, charset);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getCharset(String contentType) {
        String charset = new ContentType(contentType).getParameter("charset");
        if (charset == null || charset.trim().equals("")) {
            charset = null;
        }
        return charset;
    }

    public static String encodeFilename(String filename) {
        try {
            if (!StringUtil.isAsciiString(filename)) {
                return new QCodec().encode(filename, "utf-8");
            }
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
        return filename;
    }

    public static String getFilename(MimePart mp) {
        MimeCompoundHeader mhdr;
        String name = null;
        try {
            String cdisp = mp.getHeader("Content-Disposition", null);
            if (cdisp != null && (mhdr = new MimeCompoundHeader(cdisp)).containsParameter("filename")) {
                name = mhdr.getParameter("filename");
            }
        }
        catch (MessagingException me) {
            // empty catch block
        }
        if (name == null) {
            try {
                String ctype = mp.getHeader("Content-Type", null);
                if (ctype != null && (mhdr = new MimeCompoundHeader(ctype)).containsParameter("name")) {
                    name = mhdr.getParameter("name");
                }
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        if (name == null) {
            return null;
        }
        if (name.indexOf("&#") != -1 && name.indexOf(59) != -1) {
            return Mime.expandNumericCharacterReferences(name);
        }
        return name;
    }

    public static String expandNumericCharacterReferences(String raw) {
        if (raw == null) {
            return null;
        }
        int start = -1;
        boolean hex = false;
        int calc = 0;
        StringBuilder sb = new StringBuilder();
        int len = raw.length();
        for (int i = 0; i < len; ++i) {
            char c = raw.charAt(i);
            if (start != -1) {
                if (c >= '0' && c <= '9') {
                    calc = calc * (hex ? 16 : 10) + c - 48;
                    continue;
                }
                if (hex && c >= 'a' && c <= 'f') {
                    calc = calc * 16 + 10 + c - 97;
                    continue;
                }
                if (hex && c >= 'A' && c <= 'F') {
                    calc = calc * 16 + 10 + c - 65;
                    continue;
                }
                if (c == ';' && i > start + (hex ? 4 : 3)) {
                    sb.append((char)calc);
                    start = -1;
                    continue;
                }
                sb.append(raw.substring(start, i--));
                start = -1;
                continue;
            }
            if (c == '&' && i < len - 3 && raw.charAt(i + 1) == '#') {
                hex = raw.charAt(i + 2) == 'x' || raw.charAt(i + 2) == 'X';
                start = i;
                i += hex ? 2 : 1;
                calc = 0;
                continue;
            }
            sb.append(c);
        }
        if (start != -1) {
            sb.append(raw.substring(start));
        }
        return sb.toString();
    }

    public static MPartInfo getTextBody(List<MPartInfo> parts, boolean preferHtml) {
        for (MPartInfo mpi : Mime.getBody(parts, preferHtml)) {
            if (!mpi.getContentType().startsWith("text/")) continue;
            return mpi;
        }
        return null;
    }

    public static Set<MPartInfo> getBody(List<MPartInfo> parts, boolean preferHtml) {
        if (parts.isEmpty()) {
            return Collections.emptySet();
        }
        Set<MPartInfo> bodies = null;
        MPartInfo top = parts.get(0);
        if (!top.getContentType().startsWith("multipart/")) {
            if (!top.getDisposition().equals("attachment")) {
                bodies = new HashSet<MPartInfo>(1);
                bodies.add(top);
            }
        } else {
            bodies = Mime.getBodySubparts(top, preferHtml);
        }
        if (bodies == null) {
            bodies = Collections.emptySet();
        }
        return bodies;
    }

    public static String getHeader(MimeMessage msg, String headerName) {
        try {
            String value = msg.getHeader(headerName, null);
            if (value == null || value.length() == 0) {
                return null;
            }
            try {
                value = MimeUtility.decodeText((String)value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            value = MimeUtility.unfold((String)value);
            return value;
        }
        catch (MessagingException e) {
            sLog.debug("Unable to get header '%s'", (Object)headerName, e);
            return null;
        }
    }

    public static String[] getHeaders(MimeMessage msg, String headerName) {
        try {
            String[] values = msg.getHeader(headerName);
            if (values == null || values.length == 0) {
                return NO_HEADERS;
            }
            for (int i = 0; i < values.length; ++i) {
                try {
                    values[i] = MimeUtility.decodeText((String)values[i]);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                values[i] = MimeUtility.unfold((String)values[i]);
            }
            return values;
        }
        catch (MessagingException e) {
            sLog.debug("Unable to get headers named '%s'", (Object)headerName, e);
            return NO_HEADERS;
        }
    }

    public static String getMessageID(MimeMessage mm) {
        try {
            String msgid = mm.getMessageID();
            return "".equals(msgid) ? null : msgid;
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public static String getSubject(MimeMessage mm) throws MessagingException {
        String subject = mm.getHeader("Subject", null);
        return subject == null ? null : MimeHeader.decode(subject);
    }

    public static String getSender(MimeMessage msg) {
        String decoded;
        String sender = null;
        try {
            sender = msg.getHeader("From", null);
        }
        catch (MessagingException e) {
            // empty catch block
        }
        if (sender == null) {
            try {
                sender = msg.getHeader("Sender", null);
            }
            catch (MessagingException e) {
                // empty catch block
            }
        }
        if (sender == null) {
            sender = "";
        }
        try {
            decoded = MimeUtility.decodeText((String)sender);
        }
        catch (UnsupportedEncodingException e) {
            return sender;
        }
        return decoded;
    }

    private static Set<MPartInfo> getBodySubparts(MPartInfo base, boolean preferHtml) {
        String ctype = base.getContentType();
        if (!base.hasChildren() || ctype.equals("message/rfc822")) {
            return null;
        }
        if (ctype.equals("multipart/alternative")) {
            return Mime.getAlternativeBodySubpart(base.getChildren(), preferHtml);
        }
        List<MPartInfo> children = ctype.equals("multipart/mixed") || !KNOWN_MULTIPART_TYPES.contains(ctype) ? base.getChildren() : Arrays.asList(base.getChildren().get(0));
        LinkedHashSet<MPartInfo> bodies = null;
        for (MPartInfo mpi : children) {
            String childType = mpi.getContentType();
            if (childType.startsWith("multipart/")) {
                Set<MPartInfo> found = Mime.getBodySubparts(mpi, preferHtml);
                if (found == null) continue;
                if (bodies == null) {
                    bodies = new LinkedHashSet<MPartInfo>(found.size());
                }
                bodies.addAll(found);
                continue;
            }
            if (mpi.getDisposition().equals("attachment") || childType.equalsIgnoreCase("message/rfc822")) continue;
            if (bodies == null) {
                bodies = new LinkedHashSet(1);
            }
            bodies.add(mpi);
        }
        return bodies;
    }

    private static Set<MPartInfo> getAlternativeBodySubpart(List<MPartInfo> children, boolean preferHtml) {
        Set<MPartInfo> body;
        MPartInfo alternative = null;
        for (MPartInfo mpi : children) {
            boolean isAttachment = mpi.getDisposition().equals("attachment");
            String wantType = preferHtml ? "text/html" : "text/plain";
            Set<String> altTypes = preferHtml ? HTML_ALTERNATES : TEXT_ALTERNATES;
            String ctype = mpi.getContentType();
            if (!isAttachment && ctype.equals(wantType)) {
                body = new LinkedHashSet<MPartInfo>(1);
                body.add(mpi);
                return body;
            }
            if (!isAttachment && altTypes.contains(ctype)) {
                if (alternative != null && alternative.getContentType().equalsIgnoreCase(ctype)) continue;
                alternative = mpi;
                continue;
            }
            if (!ctype.startsWith("multipart/") || (body = Mime.getBodySubparts(mpi, preferHtml)) == null) continue;
            return body;
        }
        if (alternative == null) {
            return null;
        }
        body = new LinkedHashSet<MPartInfo>(1);
        body.add(alternative);
        return body;
    }

    public static void main(String[] args) throws MessagingException, IOException {
        int num;
        String s = URLDecoder.decode("Zimbra%20&#26085;&#26412;&#35486;&#21270;&#12398;&#32771;&#24942;&#28857;.txt", "utf-8");
        System.out.println(s);
        System.out.println(Mime.expandNumericCharacterReferences("Zimbra%20&#26085;&#26412;&#35486;&#21270;&#12398;&#32771;&#24942;&#28857;.txt&#x40;&;&#;&#x;&#&#3876;&#55"));
        FixedMimeMessage mm = new FixedMimeMessage(JMSession.getSession(), new FileInputStream("C:\\Temp\\mail\\24245"));
        InputStream is = new RawContentMultipartDataSource((MimePart)mm, new ContentType(mm.getContentType())).getInputStream();
        byte[] buf = new byte[1024];
        while ((num = is.read(buf)) != -1) {
            System.out.write(buf, 0, num);
        }
    }

    public static InputStream getInputStream(MimeMessage msg) throws IOException {
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        Thread thread = new Thread(new MimeMessageOutputThread(msg, out));
        thread.setName("MimeMessageThread");
        thread.start();
        return in;
    }

    private static final class InputStreamDataSource
    implements DataSource {
        private InputStream is;
        private String type;

        InputStreamDataSource(InputStream stream, String contentType) {
            this.is = stream;
            this.type = contentType;
        }

        public String getContentType() {
            return this.type;
        }

        public String getName() {
            return null;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public OutputStream getOutputStream() {
            return null;
        }
    }

    private static class RawContentMultipartDataSource
    extends FixedMultipartDataSource {
        RawContentMultipartDataSource(MimePart mp, ContentType ctype) {
            super(mp, ctype);
        }

        public InputStream getInputStream() throws IOException {
            return new RawContentInputStream(super.getInputStream());
        }

        private class RawContentInputStream
        extends FilterInputStream {
            private final String mBoundary;
            private byte[] mPrologue;
            private byte[] mEpilogue;
            private int mPrologueIndex;
            private int mEpilogueIndex;
            private boolean mInPrologue;
            private boolean mInContent;
            private boolean mInEpilogue;

            RawContentInputStream(InputStream is) {
                super(is);
                this.mPrologueIndex = 0;
                this.mEpilogueIndex = 0;
                this.mInPrologue = true;
                this.mInContent = false;
                this.mInEpilogue = false;
                String explicitBoundary = RawContentMultipartDataSource.this.getParsedContentType().getParameter("boundary");
                this.mBoundary = explicitBoundary == null ? "_-_" + UUID.randomUUID().toString() : explicitBoundary;
                byte[] boundary = this.mBoundary.getBytes();
                this.mPrologue = new byte[2 + boundary.length + 4];
                this.mPrologue[1] = 45;
                this.mPrologue[0] = 45;
                System.arraycopy(boundary, 0, this.mPrologue, 2, boundary.length);
                this.mPrologue[boundary.length + 4] = 13;
                this.mPrologue[boundary.length + 2] = 13;
                this.mPrologue[boundary.length + 5] = 10;
                this.mPrologue[boundary.length + 3] = 10;
                this.mEpilogue = new byte[4 + boundary.length + 4];
                this.mEpilogue[boundary.length + 6] = 13;
                this.mEpilogue[0] = 13;
                this.mEpilogue[boundary.length + 7] = 10;
                this.mEpilogue[1] = 10;
                this.mEpilogue[3] = 45;
                this.mEpilogue[2] = 45;
                System.arraycopy(boundary, 0, this.mEpilogue, 4, boundary.length);
                this.mEpilogue[boundary.length + 5] = 45;
                this.mEpilogue[boundary.length + 4] = 45;
            }

            public int available() throws IOException {
                return this.mPrologue.length - this.mPrologueIndex + super.available() + this.mEpilogue.length - this.mEpilogueIndex;
            }

            public int read() throws IOException {
                int c;
                if (this.mInPrologue) {
                    c = this.mPrologue[this.mPrologueIndex++];
                    if (this.mPrologueIndex >= this.mPrologue.length) {
                        this.mInPrologue = false;
                        this.mInContent = true;
                    }
                } else if (this.mInContent) {
                    c = super.read();
                    if (c == -1) {
                        c = this.mEpilogue[0];
                        this.mEpilogueIndex = 1;
                        this.mInContent = false;
                        this.mInEpilogue = true;
                    }
                } else if (this.mInEpilogue) {
                    c = this.mEpilogue[this.mEpilogueIndex++];
                    if (this.mEpilogueIndex >= this.mEpilogue.length) {
                        this.mInEpilogue = false;
                    }
                } else {
                    c = -1;
                }
                return c;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                if (!(this.mInPrologue || this.mInContent || this.mInEpilogue)) {
                    return -1;
                }
                int remaining = len;
                if (this.mInPrologue) {
                    int prologue = Math.min(remaining, this.mPrologue.length - this.mPrologueIndex);
                    System.arraycopy(this.mPrologue, this.mPrologueIndex, b, off, prologue);
                    this.mPrologueIndex += prologue;
                    if (this.mPrologueIndex >= this.mPrologue.length) {
                        this.mInPrologue = false;
                        this.mInContent = true;
                    }
                    remaining -= prologue;
                    off += prologue;
                }
                if (remaining == 0) {
                    return len;
                }
                if (this.mInContent) {
                    int content = super.read(b, off, remaining);
                    if (content == -1) {
                        this.mInContent = false;
                        this.mInEpilogue = true;
                    } else {
                        remaining -= content;
                        off += content;
                    }
                }
                if (remaining == 0) {
                    return len;
                }
                if (this.mInEpilogue) {
                    int epilogue = Math.min(remaining, this.mEpilogue.length - this.mEpilogueIndex);
                    System.arraycopy(this.mEpilogue, this.mEpilogueIndex, b, off, epilogue);
                    this.mEpilogueIndex += epilogue;
                    if (this.mEpilogueIndex >= this.mEpilogue.length) {
                        this.mInEpilogue = false;
                    }
                    remaining -= epilogue;
                    off += epilogue;
                }
                return len - remaining;
            }
        }
    }

    private static class FixedMultipartDataSource
    implements DataSource {
        private final MimePart mMimePart;
        private final ContentType mContentType;

        FixedMultipartDataSource(MimePart mp, ContentType ctype) {
            this.mMimePart = mp;
            this.mContentType = ctype;
        }

        public ContentType getParsedContentType() {
            return this.mContentType;
        }

        public String getContentType() {
            return this.mContentType.toString();
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            try {
                return Mime.getRawInputStream(this.mMimePart);
            }
            catch (MessagingException e) {
                IOException ioex = new IOException("failed to get raw input stream for mime part");
                ioex.initCause(e);
                throw ioex;
            }
        }
    }

    public static class FixedMimeMessage
    extends MimeMessage {
        public FixedMimeMessage(Session s) {
            super(s);
        }

        public FixedMimeMessage(Session s, InputStream is) throws MessagingException {
            super(s, is);
        }

        public FixedMimeMessage(MimeMessage mm) throws MessagingException {
            super(mm);
        }

        public Session getSession() {
            return this.session;
        }

        public FixedMimeMessage setSession(Session s) {
            this.session = s;
            return this;
        }

        protected void updateHeaders() throws MessagingException {
            String msgid = this.getMessageID();
            super.updateHeaders();
            if (msgid != null) {
                this.setHeader("Message-ID", msgid);
            }
        }
    }
}

