/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.mime.ContentType;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPartInfo {
    MimePart mPart;
    MPartInfo mParent;
    List<MPartInfo> mChildren;
    String mPartName;
    String mContentType;
    String mDisposition;
    String mFilename;
    int mPartNum;
    int mSize;
    boolean mIsFilterableAttachment;
    boolean mIsToplevelAttachment;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MPartInfo: {");
        sb.append("partName: ").append(this.mPartName).append(", ");
        sb.append("contentType: ").append(this.mContentType).append(", ");
        sb.append("size: ").append(this.mSize).append(", ");
        sb.append("disposition: ").append(this.mDisposition).append(", ");
        sb.append("filename: ").append(this.mFilename).append(", ");
        sb.append("partNum: ").append(this.mPartNum).append(", ");
        sb.append("isFilterableAttachment: ").append(this.mIsFilterableAttachment);
        sb.append("}");
        return sb.toString();
    }

    public boolean isFilterableAttachment() {
        return this.mIsFilterableAttachment;
    }

    public MimePart getMimePart() {
        return this.mPart;
    }

    public MPartInfo getParent() {
        return this.mParent;
    }

    public boolean hasChildren() {
        return this.mChildren != null && !this.mChildren.isEmpty();
    }

    public List<MPartInfo> getChildren() {
        return this.mChildren;
    }

    public String getPartName() {
        return this.mPartName;
    }

    public int getPartNum() {
        return this.mPartNum;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getContentTypeParameter(String name) {
        try {
            return new ContentType(this.mPart.getContentType()).getParameter(name);
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public String getDisposition() {
        return this.mDisposition;
    }

    public String getFilename() {
        return this.mFilename;
    }
}

