/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.MimeVisitor;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class ExpandMimeMessage {
    private static Log sLog = LogFactory.getLog(ExpandMimeMessage.class);
    private MimeMessage mMimeMessage;
    private MimeMessage mExpandedMessage;

    public ExpandMimeMessage(MimeMessage original) {
        this.mMimeMessage = original;
        this.mExpandedMessage = original;
    }

    public MimeMessage getExpanded() {
        return this.mExpandedMessage;
    }

    public boolean wasExpanded() {
        return this.mExpandedMessage != this.mMimeMessage;
    }

    public boolean expand() throws MessagingException {
        ForkMimeMessage forkCallback = new ForkMimeMessage();
        try {
            for (Class<? extends MimeVisitor> vclass : MimeVisitor.getConverters()) {
                if (this.mExpandedMessage == this.mMimeMessage) {
                    vclass.newInstance().setCallback(forkCallback).accept(this.mMimeMessage);
                }
                if (this.mExpandedMessage == this.mMimeMessage) continue;
                vclass.newInstance().accept(this.mExpandedMessage);
            }
        }
        catch (IllegalAccessException e) {
            this.mExpandedMessage = this.mMimeMessage;
            throw new MessagingException("Unable to instantiate MimeVisitor", (Exception)e);
        }
        catch (InstantiationException e) {
            this.mExpandedMessage = this.mMimeMessage;
            throw new MessagingException("Unable to instantiate MimeVisitor", (Exception)e);
        }
        return this.wasExpanded();
    }

    private class ForkMimeMessage
    implements MimeVisitor.ModificationCallback {
        private boolean mForked = false;

        private ForkMimeMessage() {
        }

        public boolean onModification() {
            if (this.mForked) {
                return false;
            }
            try {
                this.mForked = true;
                ExpandMimeMessage.this.mExpandedMessage = new Mime.FixedMimeMessage(ExpandMimeMessage.this.mMimeMessage);
            }
            catch (Exception e) {
                sLog.warn((Object)"Unable to fork MimeMessage.", e);
            }
            return false;
        }
    }
}

