/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mime;

import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class BlobDataSource
implements DataSource {
    private MailboxBlob mBlob;
    private String mContentType;

    public BlobDataSource(MailboxBlob blob) {
        this.mBlob = blob;
    }

    public BlobDataSource(MailboxBlob blob, String ct) {
        this(blob);
        this.mContentType = ct;
    }

    public String getContentType() {
        if (this.mContentType != null) {
            return this.mContentType;
        }
        return "message/rfc822";
    }

    public InputStream getInputStream() throws IOException {
        return StoreManager.getInstance().getContent(this.mBlob);
    }

    public String getName() {
        return this.mBlob.toString();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

