/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.memcached;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.memcached.ZimbraMemcachedClient;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import net.spy.memcached.HashAlgorithm;

public class MemcachedConnector {
    private static ZimbraMemcachedClient sTheClient = new ZimbraMemcachedClient();

    public static ZimbraMemcachedClient getClient() {
        return sTheClient;
    }

    public static void startup() throws ServiceException {
        MemcachedConnector.reloadConfig();
    }

    public static boolean isConnected() {
        return sTheClient.isConnected();
    }

    public static void reloadConfig() throws ServiceException {
        Server server = Provisioning.getInstance().getLocalServer();
        String[] serverList = server.getMultiAttr("zimbraMemcachedClientServerList");
        boolean useBinaryProtocol = server.getBooleanAttr("zimbraMemcachedClientBinaryProtocolEnabled", false);
        String hashAlgorithm = server.getAttr("zimbraMemcachedClientHashAlgorithm", HashAlgorithm.KETAMA_HASH.toString());
        int expirySeconds = (int)server.getLongAttr("zimbraMemcachedClientExpirySeconds", 86400L);
        long timeoutMillis = server.getLongAttr("zimbraMemcachedClientTimeoutMillis", 10000L);
        sTheClient.connect(serverList, useBinaryProtocol, hashAlgorithm, expirySeconds, timeoutMillis);
    }

    public static void shutdown() throws ServiceException {
        sTheClient.disconnect(30000L);
    }
}

