/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import com.zimbra.cs.mailclient.util.Ascii;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TraceOutputStream
extends OutputStream {
    private final OutputStream out;
    private final PrintStream traceOut;
    private String prefix = "C: ";
    private boolean enabled = true;
    private boolean eol = true;
    private boolean closed;
    private static final String PREFIX = "C: ";

    public TraceOutputStream(OutputStream out, PrintStream traceOut) {
        this.out = out;
        this.traceOut = traceOut != null ? traceOut : System.out;
    }

    public TraceOutputStream(OutputStream out) {
        this(out, System.out);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean suspendTrace(String msg) {
        if (this.closed || !this.enabled) {
            return false;
        }
        if (msg != null) {
            if (this.eol) {
                this.traceOut.print(this.prefix);
            }
            this.traceOut.print(msg);
            this.eol = msg.endsWith("\n");
        }
        this.enabled = false;
        return true;
    }

    public void resumeTrace() {
        this.enabled = true;
    }

    public void write(int b) throws IOException {
        this.checkClosed();
        this.out.write(b);
        if (this.enabled) {
            if (this.eol) {
                this.traceOut.print(this.prefix);
            }
            this.printByte((byte)b);
            this.eol = b == 10;
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.checkClosed();
        if (this.enabled) {
            while (--len >= 0) {
                this.write(buf[off++]);
            }
        } else {
            this.out.write(buf, off, len);
        }
    }

    public void flush() throws IOException {
        this.checkClosed();
        this.out.flush();
        if (this.enabled) {
            this.traceOut.flush();
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.traceOut.flush();
            this.out.close();
            this.closed = true;
        }
    }

    private void printByte(byte b) {
        switch (b) {
            case 13: {
                break;
            }
            case 10: {
                this.traceOut.println();
                break;
            }
            default: {
                this.traceOut.print(Ascii.pp(b));
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }
}

