/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import com.zimbra.cs.mailclient.util.Ascii;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class TraceInputStream
extends InputStream {
    private final InputStream in;
    private final PrintStream traceOut;
    private String prefix = "S: ";
    private boolean enabled = true;
    private boolean eol = true;
    private boolean closed;
    private static final String PREFIX = "S: ";

    public TraceInputStream(InputStream in, PrintStream traceOut) {
        this.in = in;
        this.traceOut = traceOut != null ? traceOut : System.out;
    }

    public TraceInputStream(InputStream in) {
        this(in, System.out);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean suspendTrace(String msg) {
        if (this.closed || !this.enabled) {
            return false;
        }
        if (msg != null) {
            if (this.eol) {
                this.traceOut.print(this.prefix);
            }
            this.traceOut.print(msg);
            this.eol = msg.endsWith("\n");
        }
        this.enabled = false;
        return true;
    }

    public void resumeTrace() {
        this.enabled = true;
    }

    public int read() throws IOException {
        this.checkClosed();
        int b = this.in.read();
        if (b != -1 && this.enabled) {
            if (this.eol) {
                this.traceOut.print(this.prefix);
            }
            this.printByte((byte)b);
            this.eol = b == 10;
        }
        return b;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        this.checkClosed();
        if (!this.enabled) {
            return this.in.read(buf, off, len);
        }
        int start = off;
        int end = off + len;
        while (off < end) {
            int b = this.read();
            if (b == -1) {
                int total = off - start;
                return total > 0 ? total : -1;
            }
            buf[off++] = (byte)b;
        }
        return off - start;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.traceOut.flush();
            this.in.close();
            this.closed = true;
        }
    }

    private void printByte(byte b) {
        switch (b) {
            case 13: {
                break;
            }
            case 10: {
                this.traceOut.println();
                break;
            }
            default: {
                this.traceOut.print(Ascii.pp(b));
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }
}

