/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import java.io.IOException;
import java.lang.reflect.Method;

public final class Password {
    private final Method readPassword = Password.getReadPassword();
    private static final Password INSTANCE = new Password();

    public static String read(String prompt) {
        return INSTANCE.readPassword(prompt);
    }

    private Password() {
    }

    private static Method getReadPassword() {
        try {
            Class<?> cls = Class.forName("java.io.Console");
            return cls.getMethod("readPassword", String.class, Object[].class);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private String readPassword(String prompt) {
        if (this.readPassword != null) {
            try {
                return new String((char[])this.readPassword.invoke(null, "%s", prompt));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return Password.defaultReadPassword(prompt);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String defaultReadPassword(String prompt) throws IOException {
        int c;
        System.out.print(prompt);
        System.out.flush();
        StringBuilder sb = new StringBuilder();
        while ((c = System.in.read()) != -1 && c != 10) {
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }
}

