/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitInputStream
extends FilterInputStream {
    private int remaining;

    public LimitInputStream(InputStream is, int count) {
        super(is);
        this.remaining = count;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.remaining <= 0) {
            return -1;
        }
        if (len > this.remaining) {
            len = this.remaining;
        }
        if ((len = this.in.read(b, off, len)) < 0) {
            throw new EOFException("Unexpected end of stream");
        }
        this.remaining -= len;
        return len;
    }

    public int read() throws IOException {
        if (this.remaining <= 0) {
            return -1;
        }
        int c = this.in.read();
        if (c < 0) {
            throw new EOFException("Unexpected end of stream");
        }
        --this.remaining;
        return c;
    }

    public int available() throws IOException {
        return Math.min(this.remaining, this.in.available());
    }

    public long skip(long n) throws IOException {
        if (n > (long)this.remaining) {
            n = this.remaining;
        }
        if (n <= 0L) {
            return 0L;
        }
        int skipped = (int)this.in.skip(n);
        this.remaining -= skipped;
        return skipped;
    }

    public void close() {
    }
}

