/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Io {
    public static void readFully(InputStream is, byte[] b, int off, int len) throws IOException {
        new DataInputStream(is).readFully(b, off, len);
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        Io.readFully(is, b, 0, b.length);
    }

    public static void copyBytes(InputStream is, OutputStream os, int len) throws IOException {
        byte[] b = new byte[4096];
        while (len > 0) {
            int n = is.read(b, 0, Math.min(b.length, len));
            if (n == -1) {
                throw new EOFException("Unexpected end of stream");
            }
            os.write(b, 0, n);
            len -= n;
        }
    }

    public static void copyBytes(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] b = new byte[4096];
        while ((len = is.read(b, 0, b.length)) != -1) {
            os.write(b, 0, len);
        }
    }

    public static String toString(List<Object> items, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<Object> it = items.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(separator).append(it.next());
            }
        }
        return sb.toString();
    }
}

