/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class Config {
    public static Properties toProperties(Object bean) {
        Properties props = new Properties();
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                Object value;
                if (!Config.isSupportedProperty(pd) || (value = pd.getReadMethod().invoke(bean, new Object[0])) == null) continue;
                props.setProperty(pd.getName(), value.toString());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid config bean", e);
        }
        return props;
    }

    public static void applyProperties(Object bean, Properties props) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                String name = pd.getName();
                String value = props.getProperty(name);
                if (value == null || !Config.isSupportedProperty(pd)) continue;
                Object obj = Config.parseValue(value, pd.getPropertyType());
                pd.getWriteMethod().invoke(bean, obj);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid bean", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        Properties props = new Properties();
        try {
            props.load(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(File file, Properties props) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            props.store(os, null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    private static boolean isSupportedProperty(PropertyDescriptor pd) {
        if (pd.getReadMethod() == null || pd.getWriteMethod() == null) {
            return false;
        }
        Class<?> type = pd.getPropertyType();
        return type == Long.class || type == Long.TYPE || type == Integer.class || type == Integer.TYPE || type == Short.class || type == Short.TYPE || type == Character.class || type == Character.TYPE || type == Byte.class || type == Byte.TYPE || type == Boolean.class || type == Boolean.TYPE || type == String.class || type.isEnum();
    }

    private static Object parseValue(String value, Class type) {
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.parseShort(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            if (value.length() != 1) {
                throw new IllegalArgumentException("Invalid character value: " + value);
            }
            return Character.valueOf(value.charAt(0));
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.parseByte(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (type == String.class) {
            return value;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        return null;
    }
}

