/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buf;

    public ByteBufferOutputStream(int size) {
        this.buf = ByteBuffer.allocate(size);
    }

    public ByteBufferOutputStream() {
        this(32);
    }

    public void write(int b) throws IOException {
        this.ensureCapacity(1);
        this.buf.put((byte)b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(len);
        this.buf.put(b, off, len);
    }

    private void ensureCapacity(int count) throws IOException {
        if (this.buf.remaining() < count) {
            int size = Math.max(this.buf.capacity() * 2, this.buf.capacity() + count);
            if (size < 0) {
                throw new IOException("buffer limit exceeded");
            }
            ByteBuffer tmp = ByteBuffer.allocate(size);
            this.buf.flip();
            tmp.put(this.buf);
            this.buf = tmp;
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }
}

