/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer bb) {
        this.buf = bb.duplicate();
        this.buf.rewind().mark();
    }

    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buf.remaining() == 0) {
            return -1;
        }
        if (len > this.buf.remaining()) {
            len = this.buf.remaining();
        }
        this.buf.get(b, off, len);
        return len;
    }

    public int read() {
        if (this.buf.remaining() == 0) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    public long skip(long n) {
        if (n < 0L) {
            return 0L;
        }
        if (n > (long)this.buf.remaining()) {
            n = this.buf.remaining();
        }
        this.buf.position(this.buf.position() + (int)n);
        return n;
    }

    public int available() {
        return this.buf.remaining();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int limit) {
        this.buf.mark();
    }

    public void reset() {
        this.buf.reset();
    }
}

