/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class Ascii {
    public static String pp(byte b) {
        switch (b) {
            case 0: {
                return "\\0";
            }
            case 8: {
                return "\\b";
            }
            case 13: {
                return "\\r";
            }
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 12: {
                return "\\f";
            }
        }
        return b >= 32 && b <= 126 ? String.valueOf((char)b) : "\\0x" + Ascii.toHexChar(b >> 4 & 0xF) + Ascii.toHexChar(b & 0xF);
    }

    public static char toHexChar(int digit) {
        switch (digit) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return (char)(48 + digit);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return (char)(97 + digit - 10);
            }
        }
        throw new IllegalArgumentException(String.valueOf(digit));
    }

    public static String toString(byte[] b) {
        char[] c = new char[b.length];
        for (int i = 0; i < b.length; ++i) {
            c[i] = (char)(b[i] & 0xFF);
        }
        return new String(c);
    }

    public static String toString(ByteBuffer bb) {
        bb = bb.slice();
        char[] c = new char[bb.remaining()];
        int i = 0;
        while (bb.hasRemaining()) {
            c[i] = (char)(bb.get() & 0xFF);
            ++i;
        }
        return new String(c);
    }

    public static byte[] getBytes(String s) {
        byte[] b = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    public static void write(OutputStream os, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            os.write(s.charAt(i));
        }
    }
}

