/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.smtp;

import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmtpReply {
    private int code;
    private List<String> lines;

    public static SmtpReply read(MailInputStream is) throws IOException {
        String line;
        SmtpReply reply = new SmtpReply();
        reply.lines = new ArrayList<String>();
        do {
            line = is.readLine();
            int code = SmtpReply.parseCode(line);
            if (reply.code == 0) {
                reply.code = code;
            } else if (code != reply.code) {
                throw new ParseException("Inconsistent reply code: expected " + reply.code + " but got " + code);
            }
            if (line.length() <= 3) continue;
            reply.lines.add(line.substring(4));
        } while (line.length() > 3 && line.charAt(3) != ' ');
        return reply;
    }

    private static int parseCode(String line) throws ParseException {
        int i;
        for (i = 0; i < line.length() && Character.isDigit(line.charAt(i)); ++i) {
        }
        String s = line.substring(0, i);
        if (i == 3) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ParseException("Invalid reply code: " + s);
    }

    private SmtpReply() {
    }

    public int getCode() {
        return this.code;
    }

    public List<String> getLines() {
        return this.lines;
    }
}

