/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.smtp;

import com.zimbra.cs.mailclient.MailOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmtpCommand {
    private final String name;
    private final List<String> params;
    public static final String HELO = "HELO";
    public static final String EHLO = "EHLO";
    public static final String MAIL = "MAIL";
    public static final String RCPT = "RCPT";
    public static final String DATA = "DATA";
    public static final String RSET = "RSET";
    public static final String VRFY = "VRFY";
    public static final String EXPN = "EXPN";
    public static final String NOOP = "NOOP";
    public static final String HELP = "HELP";
    public static final String QUIT = "QUIT";

    public static SmtpCommand helo(String domain) {
        return new SmtpCommand(HELO, Arrays.asList(domain));
    }

    public static SmtpCommand ehlo(String domain) {
        return new SmtpCommand(EHLO, Arrays.asList(domain));
    }

    public static SmtpCommand mail(String from, String ... mailParams) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("FROM:" + SmtpCommand.address(from));
        if (mailParams != null) {
            params.addAll(Arrays.asList(mailParams));
        }
        return new SmtpCommand(MAIL, params);
    }

    public static SmtpCommand rcpt(String to, String ... rcptParams) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("TO:" + SmtpCommand.address(to));
        if (rcptParams != null) {
            params.addAll(Arrays.asList(rcptParams));
        }
        return new SmtpCommand(RCPT, params);
    }

    public static SmtpCommand data() {
        return new SmtpCommand(DATA, null);
    }

    public static SmtpCommand rset() {
        return new SmtpCommand(RSET, null);
    }

    public static SmtpCommand vrfy(String arg) {
        return new SmtpCommand(VRFY, Arrays.asList(arg));
    }

    public static SmtpCommand expn(String arg) {
        return new SmtpCommand(EXPN, Arrays.asList(arg));
    }

    public static SmtpCommand noop(String ... params) {
        return new SmtpCommand(NOOP, Arrays.asList(params));
    }

    public static SmtpCommand help(String ... params) {
        return new SmtpCommand(HELP, Arrays.asList(params));
    }

    public static SmtpCommand quit() {
        return new SmtpCommand(QUIT, null);
    }

    private static String address(String addr) {
        return !addr.startsWith("<") && !addr.endsWith(">") ? "<" + addr + ">" : addr;
    }

    public SmtpCommand(String name, List<String> params) {
        this.name = name;
        this.params = params;
    }

    public void write(MailOutputStream os) throws IOException {
        os.write(this.name);
        if (this.params != null && !this.params.isEmpty()) {
            for (String param : this.params) {
                os.write(32);
                os.write(param);
            }
        }
        os.newLine();
    }
}

