/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.pop3;

import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.pop3.ContentInputStream;
import java.io.EOFException;
import java.io.IOException;

public class Pop3Response {
    private final String command;
    private String status;
    private String message;
    private ContentInputStream cis;
    private static final String OK = "+OK";
    private static final String ERR = "-ERR";
    private static final String CONTINUATION = "+";
    private static final String CAPA = "CAPA";
    private static final String LIST = "LIST";
    private static final String RETR = "RETR";
    private static final String UIDL = "UIDL";

    public static Pop3Response read(String cmd, MailInputStream is) throws IOException {
        Pop3Response res = new Pop3Response(cmd);
        res.readResponse(is);
        return res;
    }

    private Pop3Response(String cmd) {
        this.command = cmd;
    }

    private void readResponse(MailInputStream is) throws IOException {
        String line = is.readLine();
        if (line == null) {
            throw new EOFException("Unexpected end of stream");
        }
        int i = line.indexOf(32);
        if (i == -1) {
            this.status = line;
            this.message = "";
        } else {
            this.status = line.substring(0, i);
            this.message = line.substring(i).trim();
        }
        if (this.isOK() && Pop3Response.hasContent(this.command)) {
            this.cis = new ContentInputStream(is);
        }
    }

    private static boolean hasContent(String cmd) {
        return LIST.equalsIgnoreCase(cmd) || RETR.equalsIgnoreCase(cmd) || UIDL.equalsIgnoreCase(cmd) || CAPA.equalsIgnoreCase(cmd);
    }

    public boolean isOK() {
        return this.status.equals(OK);
    }

    public boolean isERR() {
        return this.status.equals(ERR);
    }

    public boolean isContinuation() {
        return this.status.equals(CONTINUATION);
    }

    public String getMessage() {
        return this.message;
    }

    public ContentInputStream getContentInputStream() {
        return this.cis;
    }

    public void dispose() {
        if (this.cis != null) {
            try {
                this.cis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

