/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.pop3;

import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.MailConnection;
import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.MailOutputStream;
import com.zimbra.cs.mailclient.pop3.ContentInputStream;
import com.zimbra.cs.mailclient.pop3.Pop3Capabilities;
import com.zimbra.cs.mailclient.pop3.Pop3Config;
import com.zimbra.cs.mailclient.pop3.Pop3Response;
import com.zimbra.cs.mailclient.util.Ascii;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public final class Pop3Connection
extends MailConnection {
    private Pop3Capabilities capabilities;
    private int messageCount;
    private int maildropSize;
    private static final Logger LOGGER = Logger.getLogger(Pop3Connection.class);
    private static final String PASS = "PASS";
    private static final String USER = "USER";
    private static final String AUTH = "AUTH";
    private static final String STLS = "STLS";
    private static final String QUIT = "QUIT";
    private static final String CAPA = "CAPA";
    private static final String STAT = "STAT";
    private static final String LIST = "LIST";
    private static final String UIDL = "UIDL";
    private static final String DELE = "DELE";
    private static final String NOOP = "NOOP";
    private static final String RSET = "RSET";
    private static final String RETR = "RETR";

    public Pop3Connection(Pop3Config config) {
        super(config);
    }

    protected MailInputStream newMailInputStream(InputStream is) {
        return new MailInputStream(is);
    }

    protected MailOutputStream newMailOutputStream(OutputStream os) {
        return new MailOutputStream(os);
    }

    public Logger getLogger() {
        return LOGGER;
    }

    protected void processGreeting() throws IOException {
        Pop3Response res = Pop3Response.read(null, this.mailIn);
        this.greeting = res.getMessage();
        if (!res.isOK()) {
            throw new MailException("Expected greeting, but got: " + res.getMessage());
        }
        this.setState(MailConnection.State.NOT_AUTHENTICATED);
        this.capabilities = this.capa();
    }

    public void login(String pass) throws IOException {
        super.login(pass);
        this.capabilities = this.capa();
        this.stat();
    }

    public void authenticate(String pass) throws LoginException, IOException {
        super.authenticate(pass);
        this.capabilities = this.capa();
        this.stat();
    }

    public void logout() throws IOException {
        this.quit();
    }

    protected void sendLogin(String user, String pass) throws IOException {
        this.sendCommandCheckStatus(USER, user);
        this.sendCommandCheckStatus(PASS, pass);
    }

    protected void sendAuthenticate(boolean ir) throws IOException {
        StringBuffer sb = new StringBuffer(this.authenticator.getMechanism());
        if (ir) {
            byte[] response = this.authenticator.getInitialResponse();
            sb.append(' ');
            sb.append(Ascii.toString(Base64.encodeBase64((byte[])response)));
        }
        this.sendCommandCheckStatus(AUTH, sb.toString());
    }

    protected void sendStartTls() throws IOException {
        this.sendCommandCheckStatus(STLS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pop3Capabilities capa() throws IOException {
        Pop3Response res = this.sendCommand(CAPA, null);
        if (!res.isOK()) {
            return null;
        }
        try {
            Pop3Capabilities pop3Capabilities = Pop3Capabilities.read(res.getContentInputStream());
            Object var4_3 = null;
            res.dispose();
            return pop3Capabilities;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            res.dispose();
            throw throwable;
        }
    }

    private void stat() throws IOException {
        Pop3Response res = this.sendCommandCheckStatus(STAT, null);
        String[] parts = Pop3Connection.split(res.getMessage());
        if (parts.length > 1) {
            try {
                this.messageCount = Integer.parseInt(parts[0]);
                this.maildropSize = Integer.parseInt(parts[1]);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new CommandFailedException(STAT, "Invalid STAT response: " + res.getMessage());
    }

    public Pop3Capabilities getCapabilities() {
        return this.capabilities;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getMaildropSize() {
        return this.maildropSize;
    }

    public int getMessageSize(int msgno) throws IOException {
        Pop3Response res = this.sendCommand(LIST, msgno);
        if (res.isOK()) {
            String[] parts = Pop3Connection.split(res.getMessage());
            if (parts.length > 1) {
                try {
                    return Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            throw new CommandFailedException(LIST, "Invalid LIST response: " + res.getMessage());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] getMessageSizes() throws IOException {
        Integer[] sizes = new Integer[this.messageCount];
        Pop3Response res = this.sendCommandCheckStatus(LIST, null);
        try {
            String[] parts;
            String line;
            ContentInputStream is = res.getContentInputStream();
            while ((line = is.readLine()) != null && (parts = Pop3Connection.split(line)).length >= 2) {
                try {
                    int msgno = Integer.parseInt(parts[0]);
                    int size = Integer.parseInt(parts[1]);
                    sizes[msgno - 1] = size;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (line != null) {
                throw new CommandFailedException(LIST, "Invalid LIST response: " + line);
            }
            Integer[] integerArray = sizes;
            Object var9_9 = null;
            res.dispose();
            return integerArray;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            res.dispose();
            throw throwable;
        }
    }

    public String getMessageUid(int msgno) throws IOException {
        Pop3Response res = this.sendCommand(UIDL, msgno);
        if (res.isOK()) {
            String[] parts = Pop3Connection.split(res.getMessage());
            if (parts.length < 2) {
                throw new CommandFailedException(UIDL, "Invalid UIDL response: " + res.getMessage());
            }
            return parts[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMessageUids() throws IOException {
        String[] uids = new String[this.messageCount];
        Pop3Response res = this.sendCommandCheckStatus(UIDL, null);
        try {
            String[] parts;
            String line;
            ContentInputStream is = res.getContentInputStream();
            while ((line = is.readLine()) != null && (parts = Pop3Connection.split(line)).length >= 2) {
                try {
                    String uid;
                    int msgno = Integer.parseInt(parts[0]);
                    uids[msgno - 1] = uid = parts[1];
                }
                catch (Exception e) {
                    break;
                }
            }
            if (line != null) {
                throw new CommandFailedException(LIST, "Invalid UIDL response: " + line);
            }
            String[] stringArray = uids;
            Object var9_9 = null;
            res.dispose();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            res.dispose();
            throw throwable;
        }
    }

    public ContentInputStream getMessage(int msgno) throws IOException {
        return this.sendCommandCheckStatus(RETR, msgno).getContentInputStream();
    }

    public boolean deleteMessage(int msgno) throws IOException {
        return this.sendCommand(DELE, msgno).isOK();
    }

    public void reset() throws IOException {
        this.sendCommandCheckStatus(RSET, null);
    }

    public void noop() throws IOException {
        this.sendCommandCheckStatus(NOOP, null);
    }

    public void quit() throws IOException {
        this.setState(MailConnection.State.LOGOUT);
        this.sendCommandCheckStatus(QUIT, null);
        this.setState(MailConnection.State.CLOSED);
    }

    public boolean hasCapability(String cap) {
        return this.capabilities != null && this.capabilities.hasCapability(cap);
    }

    public Pop3Config getPop3Config() {
        return (Pop3Config)this.config;
    }

    public Pop3Response sendCommand(String cmd, Object args) throws IOException {
        this.mailOut.write(cmd);
        if (args != null) {
            this.mailOut.write(32);
            if (cmd.equalsIgnoreCase(PASS)) {
                this.writePass(args.toString());
            } else {
                this.mailOut.write(args.toString());
            }
        }
        this.mailOut.newLine();
        this.mailOut.flush();
        Pop3Response res;
        while ((res = Pop3Response.read(cmd, this.mailIn)).isContinuation()) {
            this.processContinuation(res.getMessage());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePass(String pass) throws IOException {
        if (this.traceOut != null && this.traceOut.suspendTrace("<password>")) {
            try {
                this.mailOut.write(pass);
                Object var3_2 = null;
                this.traceOut.resumeTrace();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.traceOut.resumeTrace();
                throw throwable;
            }
        } else {
            this.mailOut.write(pass);
        }
    }

    public Pop3Response sendCommandCheckStatus(String cmd, Object args) throws IOException {
        Pop3Response res = this.sendCommand(cmd, args);
        if (!res.isOK()) {
            throw new CommandFailedException(cmd, res.getMessage());
        }
        return res;
    }

    private static String[] split(String s) {
        return s.trim().split("[ \\t]+");
    }
}

