/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.pop3;

import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.util.Config;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class Pop3Config
extends MailConfig {
    public static final String PROTOCOL = "pop3";
    public static final int DEFAULT_PORT = 110;
    public static final int DEFAULT_SSL_PORT = 995;

    public static Pop3Config load(File file) throws IOException {
        Properties props = Config.loadProperties(file);
        Pop3Config config = new Pop3Config();
        config.applyProperties(props);
        return config;
    }

    public Pop3Config() {
    }

    public Pop3Config(String host) {
        super(host);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public int getPort() {
        int port = super.getPort();
        if (port != -1) {
            return port;
        }
        return this.getSecurity() == MailConfig.Security.SSL ? 995 : 110;
    }
}

