/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.pop3;

import com.zimbra.cs.mailclient.pop3.ContentInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pop3Capabilities {
    private Map<String, List<String>> capabilities = new HashMap<String, List<String>>();
    public static final String TOP = "TOP";
    public static final String USER = "USER";
    public static final String STLS = "STLS";
    public static final String SASL = "SASL";
    public static final String RESP_CODES = "RESP-CODES";
    public static final String LOGIN_DELAY = "LOGIN-DELAY";
    public static final String PIPELINING = "PIPELINING";
    public static final String EXPIRE = "EXPIRE";
    public static final String UIDL = "UIDL";
    public static final String IMPLEMENTATION = "IMPLEMENTATION";

    public static Pop3Capabilities read(ContentInputStream is) throws IOException {
        Pop3Capabilities caps = new Pop3Capabilities();
        caps.readCapabilities(is);
        return caps;
    }

    private Pop3Capabilities() {
    }

    private void readCapabilities(ContentInputStream is) throws IOException {
        String line;
        while ((line = is.readLine()) != null) {
            String[] words = line.split(" ");
            if (words.length <= 0) continue;
            String key = words[0];
            List<String> params = this.capabilities.get(key);
            if (params == null) {
                params = new ArrayList<String>();
                this.capabilities.put(key.toUpperCase(), params);
            }
            for (int i = 1; i < words.length; ++i) {
                params.add(words[i]);
            }
        }
    }

    public boolean hasCapability(String cap) {
        return this.capabilities.containsKey(cap.toUpperCase());
    }

    public boolean hasCapability(String cap, String param) {
        if (param == null) {
            return this.hasCapability(cap);
        }
        List<String> params = this.getParameters(cap);
        return params != null && params.contains(param);
    }

    public List<String> getParameters(String cap) {
        return this.capabilities.get(cap.toUpperCase());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<String, List<String>>> entries = this.capabilities.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, List<String>> e = entries.next();
            sb.append(e.getKey());
            Iterator<String> params = e.getValue().iterator();
            if (params.hasNext()) {
                sb.append("=\"").append(params.next());
                while (params.hasNext()) {
                    sb.append(' ').append(params.next());
                }
                sb.append('\"');
            }
            if (!entries.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }
}

