/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.pop3;

import com.zimbra.cs.mailclient.ParseException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class ContentInputStream
extends InputStream {
    private final InputStream in;
    private final StringBuilder sbuf;
    private int pos;

    public ContentInputStream(InputStream is) {
        this.in = is;
        this.sbuf = new StringBuilder(132);
        this.sbuf.setLength(0);
    }

    public int read() throws IOException {
        if (this.pos == -1) {
            return -1;
        }
        if (this.pos >= this.sbuf.length() && !this.fillBuffer()) {
            return -1;
        }
        return this.sbuf.charAt(this.pos++);
    }

    public String readLine() throws IOException {
        if (this.pos == -1) {
            return null;
        }
        if (this.pos >= this.sbuf.length() && !this.fillBuffer()) {
            return null;
        }
        int len = this.sbuf.length() - this.pos;
        String line = len > 2 ? this.sbuf.substring(this.pos, len - 2) : "";
        this.pos = this.sbuf.length();
        return line;
    }

    public void close() throws IOException {
        this.skipRemaining();
    }

    private void skipRemaining() throws IOException {
        while (this.read() != -1) {
        }
    }

    private boolean fillBuffer() throws IOException {
        int b;
        this.sbuf.setLength(0);
        do {
            if ((b = this.in.read()) == -1) {
                throw new EOFException("Unexpected end of stream while reading content");
            }
            this.sbuf.append((char)b);
        } while (b != 10);
        int len = this.sbuf.length();
        if (len < 2 || this.sbuf.charAt(len - 2) != '\r') {
            throw new ParseException("Invalid end of line character");
        }
        if (len == 3 && this.sbuf.charAt(0) == '.') {
            this.pos = -1;
            return false;
        }
        if (len == 4 && this.sbuf.charAt(0) == '.' && this.sbuf.charAt(1) == '.') {
            this.sbuf.deleteCharAt(0);
        }
        this.pos = 0;
        return true;
    }
}

