/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.AppendResult;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.CopyResult;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapCapabilities;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import java.io.IOException;
import java.util.ArrayList;

public final class ResponseText {
    private Atom code;
    private Object data;
    private String text;

    public static ResponseText read(ImapInputStream is) throws IOException {
        ResponseText rt = new ResponseText();
        is.skipSpaces();
        if (is.peek() == 91) {
            rt.readCode(is);
        }
        rt.text = is.readText();
        return rt;
    }

    private void readCode(ImapInputStream is) throws IOException {
        is.skipChar('[');
        this.code = is.readAtom();
        switch (this.code.getCAtom()) {
            case ALERT: 
            case PARSE: 
            case READ_ONLY: 
            case READ_WRITE: 
            case TRYCREATE: {
                break;
            }
            case UIDNEXT: 
            case UIDVALIDITY: {
                is.skipChar(' ');
                this.data = is.readNumber();
                break;
            }
            case UNSEEN: {
                is.skipChar(' ');
                this.data = is.readNumber();
                break;
            }
            case BADCHARSET: {
                if (!is.match(' ')) break;
                is.skipSpaces();
                if (is.peekChar() != '(') break;
                this.data = this.readCharset(is);
                break;
            }
            case PERMANENTFLAGS: {
                is.skipChar(' ');
                this.data = Flags.read(is);
                break;
            }
            case CAPABILITY: {
                is.skipChar(' ');
                is.skipSpaces();
                this.data = ImapCapabilities.read(is);
                break;
            }
            case APPENDUID: {
                this.data = AppendResult.parse(is);
                break;
            }
            case COPYUID: {
                this.data = CopyResult.parse(is);
                break;
            }
            default: {
                if (!is.match(' ')) break;
                this.data = is.readText(" ]");
            }
        }
        is.skipSpaces();
        is.skipChar(']');
    }

    private String[] readCharset(ImapInputStream is) throws IOException {
        ArrayList<String> cs = new ArrayList<String>();
        is.skipChar('(');
        is.skipSpaces();
        while (!is.match(')')) {
            cs.add(is.readAString());
            is.skipSpaces();
        }
        return cs.toArray(new String[cs.size()]);
    }

    public Atom getCode() {
        return this.code;
    }

    public Object getData() {
        return this.data;
    }

    public String getText() {
        return this.text;
    }

    public CAtom getCCode() {
        return this.code != null ? this.code.getCAtom() : CAtom.UNKNOWN;
    }
}

