/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.Body;
import com.zimbra.cs.mailclient.imap.BodyStructure;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Chars;
import com.zimbra.cs.mailclient.imap.Envelope;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class MessageData {
    private long msgno;
    private Flags flags;
    private Envelope envelope;
    private Date internalDate;
    private ImapData rfc822Header;
    private ImapData rfc822Text;
    private long rfc822Size = -1L;
    private BodyStructure bodyStructure;
    private List<Body> bodySections;
    private long uid = -1L;
    private static final SimpleDateFormat INTERNALDATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss Z", Locale.US);

    public static MessageData read(ImapInputStream is, long msgno) throws IOException {
        MessageData md = new MessageData();
        md.msgno = msgno;
        md.read(is);
        return md;
    }

    private MessageData() {
    }

    private void read(ImapInputStream is) throws IOException {
        is.skipSpaces();
        is.skipChar('(');
        is.skipSpaces();
        while (!is.match(')')) {
            this.readAttribute(is);
            is.skipSpaces();
        }
    }

    private void readAttribute(ImapInputStream is) throws IOException {
        String s = is.readChars(Chars.FETCH_CHARS);
        if (s.length() == 0) {
            throw new ParseException("Zero-length attribute");
        }
        Atom attr = new Atom(s);
        CAtom cattr = attr.getCAtom();
        if (cattr == CAtom.BODY && is.peek() == 91) {
            if (this.bodySections == null) {
                this.bodySections = new ArrayList<Body>();
            }
            this.bodySections.add(Body.read(is));
            return;
        }
        is.skipChar(' ');
        is.skipSpaces();
        switch (attr.getCAtom()) {
            case FLAGS: {
                this.flags = Flags.read(is);
                break;
            }
            case ENVELOPE: {
                this.envelope = Envelope.read(is);
                break;
            }
            case INTERNALDATE: {
                this.internalDate = MessageData.readInternalDate(is);
                break;
            }
            case RFC822_HEADER: {
                this.rfc822Header = is.readNStringData();
                break;
            }
            case RFC822_TEXT: {
                this.rfc822Text = is.readNStringData();
                break;
            }
            case RFC822_SIZE: {
                this.rfc822Size = is.readNumber();
                break;
            }
            case BODYSTRUCTURE: {
                this.bodyStructure = BodyStructure.read(is, true);
                break;
            }
            case BODY: {
                this.bodyStructure = BodyStructure.read(is, false);
                break;
            }
            case UID: {
                this.uid = is.readNZNumber();
                break;
            }
            default: {
                throw new ParseException("Invalid message data attribute: " + attr);
            }
        }
    }

    private static Date readInternalDate(ImapInputStream is) throws IOException {
        String s = is.readQuoted().toString().trim();
        if (s.length() == 0) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = INTERNALDATE_FORMAT;
        synchronized (simpleDateFormat) {
            try {
                return INTERNALDATE_FORMAT.parse(s);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid INTERNALDATE value: " + s);
            }
        }
    }

    public long getMsgno() {
        return this.msgno;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public ImapData getRfc822Header() {
        return this.rfc822Header;
    }

    public ImapData getRfc822Text() {
        return this.rfc822Text;
    }

    public long getRfc822Size() {
        return this.rfc822Size;
    }

    public BodyStructure getBodyStructure() {
        return this.bodyStructure;
    }

    public long getUid() {
        return this.uid;
    }

    public Body[] getBodySections() {
        return this.bodySections != null ? this.bodySections.toArray(new Body[this.bodySections.size()]) : null;
    }

    public void addFields(MessageData md) {
        if (md.flags != null) {
            this.flags = md.flags;
        }
        if (md.envelope != null) {
            this.envelope = md.envelope;
        }
        if (md.internalDate != null) {
            this.internalDate = md.internalDate;
        }
        if (md.rfc822Header != null) {
            this.rfc822Header = md.rfc822Header;
        }
        if (md.rfc822Text != null) {
            this.rfc822Text = md.rfc822Text;
        }
        if (md.rfc822Size != -1L) {
            this.rfc822Size = md.rfc822Size;
        }
        if (md.bodyStructure != null) {
            this.bodyStructure = md.bodyStructure;
        }
        if (md.bodySections != null) {
            this.bodySections = md.bodySections;
        }
        if (md.uid != -1L) {
            this.uid = md.uid;
        }
    }

    public void dispose() {
        if (this.rfc822Header != null) {
            this.rfc822Header.dispose();
        }
        if (this.rfc822Text != null) {
            this.rfc822Text.dispose();
        }
        if (this.bodySections != null) {
            for (Body body : this.bodySections) {
                body.dispose();
            }
        }
    }
}

