/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.util.Ascii;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class MailboxName {
    private String name;
    public static final MailboxName INBOX;
    private static final char[] ENCODE_PEM;
    private static final byte[] DECODE_PEM;

    public static MailboxName decode(ImapData encoded) throws IOException {
        return MailboxName.decode(ByteBuffer.wrap(encoded.getBytes()));
    }

    public static MailboxName decode(String encoded) throws ParseException {
        return MailboxName.decode(ByteBuffer.wrap(Ascii.getBytes(encoded)));
    }

    public static MailboxName decode(ByteBuffer bb) throws ParseException {
        return new MailboxName(MailboxName.decodeBytes(bb));
    }

    public MailboxName(String name) {
        this.name = name;
    }

    private static String decodeBytes(ByteBuffer bb) throws ParseException {
        StringBuffer sb = new StringBuffer(bb.remaining());
        while (bb.hasRemaining()) {
            byte c = bb.get();
            if (c < 0) {
                throw new ParseException("Not a 7-bit character: " + c);
            }
            if (c == 38) {
                MailboxName.decodePEM(bb, sb);
                continue;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private static void decodePEM(ByteBuffer bb, StringBuffer sb) throws ParseException {
        try {
            byte c = bb.get();
            if (c == 45) {
                sb.append('&');
                return;
            }
            int bits = 0;
            int count = 0;
            do {
                byte b;
                if ((b = DECODE_PEM[c & 0xFF]) == -1) {
                    throw new ParseException("Invalid Base64 character: " + c);
                }
                bits = bits << 6 | b;
                if ((count += 6) <= 15) continue;
                sb.append((char)(bits >> (count -= 16)));
                bits &= (1 << count) - 1;
            } while ((c = bb.get()) != 45);
            if (count > 0 && bits != 0) {
                throw new ParseException("Invalid Base64 encoding");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Unterminated Base64 encoding");
        }
    }

    public String encode() {
        StringBuilder sb = new StringBuilder(this.name.length());
        int index = 0;
        while (index < this.name.length()) {
            char c = this.name.charAt(index);
            if (c >= ' ' && c <= '~') {
                if (c == '&') {
                    sb.append('&').append('-');
                } else {
                    sb.append(c);
                }
                ++index;
                continue;
            }
            index = this.encodePEM(sb, index);
        }
        return sb.toString();
    }

    private int encodePEM(StringBuilder sb, int index) {
        char c;
        sb.append('&');
        int bits = 0;
        int count = 0;
        while (index < this.name.length() && ((c = this.name.charAt(index)) < ' ' || c > '~')) {
            ++index;
            bits = bits << 16 | c;
            if ((count += 2) == 4) {
                MailboxName.encodePEM(sb, bits >>> 8, 3);
                bits &= 0xFF;
                count = 1;
                continue;
            }
            if (count != 3) continue;
            MailboxName.encodePEM(sb, bits, count);
            bits = 0;
            count = 0;
        }
        if (count > 0) {
            MailboxName.encodePEM(sb, bits, count);
        }
        sb.append('-');
        return index;
    }

    private static void encodePEM(StringBuilder sb, int bits, int count) {
        switch (count) {
            case 3: {
                sb.append(MailboxName.encodePEM(bits, 18));
                sb.append(MailboxName.encodePEM(bits, 12));
                sb.append(MailboxName.encodePEM(bits, 6));
                sb.append(MailboxName.encodePEM(bits, 0));
                break;
            }
            case 2: {
                sb.append(MailboxName.encodePEM(bits <<= 2, 12));
                sb.append(MailboxName.encodePEM(bits, 6));
                sb.append(MailboxName.encodePEM(bits, 0));
                break;
            }
            case 1: {
                sb.append(MailboxName.encodePEM(bits <<= 4, 6));
                sb.append(MailboxName.encodePEM(bits, 0));
            }
        }
    }

    private static char encodePEM(int bits, int shift) {
        return ENCODE_PEM[bits >> shift & 0x3F];
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MailboxName && this.name.equals(((MailboxName)obj).name);
    }

    public String toString() {
        return this.name;
    }

    static {
        int i;
        INBOX = new MailboxName("INBOX");
        ENCODE_PEM = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', ','};
        DECODE_PEM = new byte[256];
        for (i = 0; i < 256; ++i) {
            MailboxName.DECODE_PEM[i] = -1;
        }
        for (i = 0; i < ENCODE_PEM.length; ++i) {
            MailboxName.DECODE_PEM[MailboxName.ENCODE_PEM[i]] = (byte)i;
        }
    }
}

