/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.ImapResponse;
import com.zimbra.cs.mailclient.imap.MailboxName;
import com.zimbra.cs.mailclient.imap.ResponseHandler;
import com.zimbra.cs.mailclient.imap.ResponseText;
import java.io.IOException;

public final class Mailbox
implements ResponseHandler {
    private String name;
    private Flags flags;
    private Flags permanentFlags;
    private long exists = -1L;
    private long recent = -1L;
    private long uidNext = -1L;
    private long uidValidity = -1L;
    private long unseen = -1L;
    private CAtom access;

    public Mailbox(String name) {
        this.name = name;
    }

    public Mailbox(Mailbox mb) {
        this.name = mb.name;
        this.flags = mb.flags;
        this.permanentFlags = mb.permanentFlags;
        this.exists = mb.exists;
        this.recent = mb.recent;
        this.uidNext = mb.uidNext;
        this.uidValidity = mb.uidValidity;
        this.unseen = mb.unseen;
        this.access = mb.access;
    }

    private Mailbox() {
    }

    public static Mailbox readStatus(ImapInputStream is) throws IOException {
        Mailbox mbox = new Mailbox();
        mbox.parseStatus(is);
        return mbox;
    }

    private void parseStatus(ImapInputStream is) throws IOException {
        this.name = MailboxName.decode(is.readAString()).toString();
        is.skipChar(' ');
        is.skipSpaces();
        is.skipChar('(');
        while (!is.match(')')) {
            Atom attr = is.readAtom();
            is.skipChar(' ');
            long n = is.readNumber();
            switch (attr.getCAtom()) {
                case MESSAGES: {
                    this.exists = n;
                    break;
                }
                case RECENT: {
                    this.recent = n;
                    break;
                }
                case UIDNEXT: {
                    this.uidNext = n;
                    break;
                }
                case UIDVALIDITY: {
                    this.uidValidity = n;
                    break;
                }
                case UNSEEN: {
                    this.unseen = n;
                    break;
                }
                default: {
                    throw new ParseException("Invalid STATUS response attribute: " + attr);
                }
            }
            is.skipSpaces();
        }
    }

    public void handleResponse(ImapResponse res) {
        switch (res.getCCode()) {
            case EXISTS: {
                this.exists = res.getNumber();
                break;
            }
            case RECENT: {
                this.recent = res.getNumber();
                break;
            }
            case FLAGS: {
                this.flags = (Flags)res.getData();
                break;
            }
            case OK: {
                this.handleResponseText(res.getResponseText());
            }
        }
    }

    private void handleResponseText(ResponseText rt) {
        switch (rt.getCCode()) {
            case UNSEEN: {
                this.unseen = (Long)rt.getData();
                break;
            }
            case UIDNEXT: {
                long n = (Long)rt.getData();
                if (n <= 0L) break;
                this.uidNext = n;
                break;
            }
            case UIDVALIDITY: {
                long n = (Long)rt.getData();
                if (n <= 0L) break;
                this.uidValidity = n;
                break;
            }
            case PERMANENTFLAGS: {
                this.permanentFlags = (Flags)rt.getData();
                break;
            }
            case READ_WRITE: {
                this.access = CAtom.READ_WRITE;
                break;
            }
            case READ_ONLY: {
                this.access = CAtom.READ_ONLY;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    public long getExists() {
        return this.exists;
    }

    public long getRecent() {
        return this.recent;
    }

    public long getUidNext() {
        return this.uidNext;
    }

    public long getUidValidity() {
        return this.uidValidity;
    }

    public long getUnseen() {
        return this.unseen;
    }

    public boolean isReadOnly() {
        return this.access == CAtom.READ_ONLY;
    }

    public boolean isReadWrite() {
        return this.access == CAtom.READ_WRITE;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String encoded = this.name != null ? new MailboxName(this.name).encode() : null;
        return String.format("{name=%s, exists=%d, recent=%d, unseen=%d, flags=%s, permanent_flags=%s, uid_next=%d, uid_validity=%d, access=%s}", new Object[]{encoded, this.exists, this.recent, this.unseen, this.flags, this.permanentFlags, this.uidNext, this.uidValidity, this.access});
    }
}

