/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class Literal
extends ImapData {
    private byte[] bytes;
    private final File file;
    private final InputStream stream;
    private final int size;
    private boolean tmp;

    public Literal(byte[] bytes) {
        this.bytes = bytes;
        this.file = null;
        this.stream = null;
        this.size = bytes.length;
    }

    public Literal(File file, boolean tmp) {
        this.file = file;
        this.stream = null;
        this.size = (int)file.length();
        this.tmp = tmp;
    }

    public Literal(File file) {
        this(file, false);
    }

    public Literal(InputStream is, int size) {
        this.bytes = null;
        this.file = null;
        this.stream = is;
        this.size = size;
    }

    public ImapData.Type getType() {
        return ImapData.Type.LITERAL;
    }

    public InputStream getInputStream() throws IOException {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return this.stream;
    }

    public int getSize() {
        return this.size;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] byArray;
        if (this.bytes != null) {
            return this.bytes;
        }
        DataInputStream is = new DataInputStream(this.getInputStream());
        try {
            byte[] b = new byte[this.size];
            is.readFully(b);
            byArray = b;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return byArray;
    }

    public void writePrefix(ImapOutputStream os, boolean lp) throws IOException {
        os.write(123);
        os.write(String.valueOf(this.size));
        if (lp) {
            os.write(43);
        }
        os.writeLine("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(OutputStream os) throws IOException {
        if (this.bytes != null) {
            os.write(this.bytes);
        } else {
            InputStream is = this.getInputStream();
            try {
                int len;
                byte[] b = new byte[2048];
                while ((len = is.read(b)) != -1) {
                    os.write(b, 0, len);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                is.close();
                throw throwable;
            }
            is.close();
            {
            }
        }
    }

    public String toString() {
        if (this.stream != null) {
            return String.format("[literal %d bytes]", this.size);
        }
        try {
            return new String(this.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("UTF-8 charset not found");
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error while reading literal bytes", e);
        }
    }

    public void dispose() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.file != null && this.tmp) {
            this.file.delete();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

