/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.MailboxName;
import com.zimbra.cs.mailclient.util.Ascii;
import java.io.IOException;

public final class ListData {
    private String mailbox;
    private char delimiter;
    private Flags flags;

    public static ListData read(ImapInputStream is) throws IOException {
        ListData mb = new ListData();
        mb.readMailboxList(is);
        return mb;
    }

    private ListData() {
    }

    public ListData(String mailbox, char delimiter) {
        this.mailbox = mailbox;
        this.delimiter = delimiter;
        this.flags = new Flags();
    }

    private void readMailboxList(ImapInputStream is) throws IOException {
        this.flags = ListData.readFlags(is);
        is.skipChar(' ');
        String delim = is.readNString();
        if (delim != null) {
            if (delim.length() != 1) {
                throw new ParseException("Invalid delimiter specification in LIST data: " + delim);
            }
            this.delimiter = delim.charAt(0);
        }
        is.skipChar(' ');
        is.skipSpaces();
        String s = is.peekChar() == '\"' ? ListData.readQuoted(is) : is.readAString();
        this.mailbox = MailboxName.decode(s).toString();
    }

    private static String readQuoted(ImapInputStream is) throws IOException {
        is.skipChar('\"');
        StringBuilder sb = new StringBuilder();
        while (is.peekChar() != '\r') {
            char c = is.readChar();
            if (c == '\\') {
                c = is.readChar();
            }
            sb.append(c);
        }
        String s = sb.toString();
        if (!s.endsWith("\"")) {
            throw new ParseException("Unexpected end of line while reading QUOTED string");
        }
        return s.substring(0, s.length() - 1);
    }

    private static Flags readFlags(ImapInputStream is) throws IOException {
        Flags flags = Flags.read(is);
        int count = 0;
        if (flags.isNoselect()) {
            ++count;
        }
        if (flags.isMarked()) {
            ++count;
        }
        if (flags.isUnmarked()) {
            ++count;
        }
        if (count > 1) {
            throw new ParseException("Invalid LIST flags - only one of \\Noselect, \\Marked, or \\Unmarked expected: " + flags);
        }
        return flags;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String toString() {
        return String.format("{mailbox=%s, delimiter=%s, flags=%s}", this.mailbox, Ascii.pp((byte)this.delimiter), this.flags);
    }
}

