/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Chars;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.IDInfo;
import com.zimbra.cs.mailclient.imap.ImapCapabilities;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.ListData;
import com.zimbra.cs.mailclient.imap.Mailbox;
import com.zimbra.cs.mailclient.imap.MessageData;
import com.zimbra.cs.mailclient.imap.ResponseText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImapResponse {
    private String tag;
    private long number = -1L;
    private Atom code;
    private CAtom ccode;
    private Object data;
    public static final String CONTINUATION = "+";
    public static final String UNTAGGED = "*";

    public static ImapResponse read(ImapInputStream is) throws IOException {
        ImapResponse res = new ImapResponse();
        res.readResponse(is);
        return res;
    }

    private ImapResponse() {
    }

    private void readResponse(ImapInputStream is) throws IOException {
        this.tag = is.readText(' ');
        is.skipChar(' ');
        if (this.tag.equals(CONTINUATION)) {
            this.data = ResponseText.read(is);
        } else if (this.tag.equals(UNTAGGED)) {
            this.readUntagged(is);
        } else if (Chars.isTag(this.tag)) {
            this.readTagged(is);
        } else {
            throw new ParseException("Invalid response tag: " + this.tag);
        }
        is.skipCRLF();
    }

    private void readUntagged(ImapInputStream is) throws IOException {
        this.code = is.readAtom();
        this.number = this.code.getNumber();
        if (this.number != -1L) {
            is.skipChar(' ');
            this.code = is.readAtom();
        }
        this.ccode = this.code.getCAtom();
        switch (this.ccode) {
            case OK: 
            case BAD: 
            case NO: 
            case BYE: {
                is.skipChar(' ');
                this.data = ResponseText.read(is);
                break;
            }
            case CAPABILITY: {
                if (is.match(' ')) {
                    this.data = ImapCapabilities.read(is);
                    break;
                }
                this.data = new ImapCapabilities();
                break;
            }
            case FLAGS: {
                is.skipChar(' ');
                this.data = Flags.read(is);
                break;
            }
            case LIST: 
            case LSUB: {
                is.skipChar(' ');
                this.data = ListData.read(is);
                break;
            }
            case SEARCH: {
                this.data = this.readSearchData(is);
                break;
            }
            case STATUS: {
                is.skipChar(' ');
                this.data = Mailbox.readStatus(is);
                break;
            }
            case FETCH: {
                is.skipChar(' ');
                this.data = MessageData.read(is, this.number);
                break;
            }
            case EXISTS: 
            case RECENT: 
            case EXPUNGE: {
                break;
            }
            case ID: {
                is.skipChar(' ');
                this.data = IDInfo.read(is);
                break;
            }
            default: {
                throw new ParseException("Unknown response code: " + this.code);
            }
        }
    }

    private List<Long> readSearchData(ImapInputStream is) throws IOException {
        ArrayList<Long> ids = new ArrayList<Long>();
        while (is.match(' ')) {
            is.skipSpaces();
            if (is.isEOL()) continue;
            ids.add(is.readNZNumber());
        }
        return ids;
    }

    private void readTagged(ImapInputStream is) throws IOException {
        this.code = is.readAtom();
        is.skipChar(' ');
        this.ccode = this.code.getCAtom();
        switch (this.ccode) {
            case OK: 
            case BAD: 
            case NO: {
                this.data = ResponseText.read(is);
                break;
            }
            default: {
                throw new ParseException("Invalid tagged response code: " + this.code);
            }
        }
    }

    public boolean isContinuation() {
        return CONTINUATION.equals(this.tag);
    }

    public boolean isUntagged() {
        return UNTAGGED.equals(this.tag);
    }

    public boolean isTagged() {
        return !this.isContinuation() && !this.isUntagged();
    }

    public String getTag() {
        return this.tag;
    }

    public long getNumber() {
        return this.number;
    }

    public Atom getCode() {
        return this.code;
    }

    public CAtom getCCode() {
        return this.ccode;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isOK() {
        return this.ccode == CAtom.OK;
    }

    public boolean isBAD() {
        return this.ccode == CAtom.BAD;
    }

    public boolean isNO() {
        return this.ccode == CAtom.NO;
    }

    public boolean isBYE() {
        return this.ccode == CAtom.BYE;
    }

    public boolean isStatus() {
        switch (this.ccode) {
            case OK: 
            case BAD: 
            case NO: 
            case BYE: {
                return true;
            }
        }
        return false;
    }

    public boolean isWarning() {
        return this.isNO() && !this.isTagged();
    }

    public boolean isError() {
        return this.isBAD() || this.isNO() && this.isTagged();
    }

    public ResponseText getResponseText() {
        return (ResponseText)this.data;
    }

    public String getContinuation() {
        return this.isContinuation() ? this.getResponseText().getText() : null;
    }

    public void dispose() {
        if (this.data instanceof MessageData) {
            ((MessageData)this.data).dispose();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.tag);
        sb.append(' ');
        if (this.number != -1L) {
            sb.append(this.number).append(' ');
        }
        if (this.code != null) {
            sb.append(this.code);
        }
        if (this.data != null) {
            sb.append(" <data>");
        }
        return sb.toString();
    }
}

