/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.AppendMessage;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.DataHandler;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.IDInfo;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapOutputStream;
import com.zimbra.cs.mailclient.imap.ImapResponse;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.MailboxName;
import com.zimbra.cs.mailclient.imap.Quoted;
import com.zimbra.cs.mailclient.imap.ResponseHandler;
import com.zimbra.cs.mailclient.util.DateUtil;
import com.zimbra.cs.mailclient.util.TraceOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapRequest {
    private final ImapConnection connection;
    private final String tag;
    private final Atom cmd;
    private List<Object> params;
    private ResponseHandler responseHandler;
    private DataHandler dataHandler;

    public ImapRequest(ImapConnection connection, Atom cmd) {
        this.connection = connection;
        this.tag = connection.newTag();
        this.cmd = cmd;
    }

    public ImapRequest(ImapConnection connection, Atom cmd, Object ... params) {
        this(connection, cmd);
        for (Object param : params) {
            this.addParam(param);
        }
    }

    public void addParam(Object param) {
        if (param == null) {
            throw new NullPointerException();
        }
        if (this.params == null) {
            this.params = new ArrayList<Object>();
        }
        this.params.add(param);
    }

    public void setResponseHandler(ResponseHandler handler) {
        this.responseHandler = handler;
    }

    public void setDataHandler(DataHandler handler) {
        this.dataHandler = handler;
    }

    public String getTag() {
        return this.tag;
    }

    public Atom getCommand() {
        return this.cmd;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public boolean isAuthenticate() {
        return CAtom.AUTHENTICATE.atom().equals(this.cmd);
    }

    public boolean isIdle() {
        return CAtom.IDLE.atom().equals(this.cmd);
    }

    public boolean isSelectOrExamine() {
        switch (this.cmd.getCAtom()) {
            case SELECT: 
            case EXAMINE: {
                return true;
            }
        }
        return false;
    }

    public ImapResponse send() throws IOException {
        try {
            return this.connection.sendRequest(this);
        }
        catch (SocketTimeoutException e) {
            this.connection.close();
            throw this.failed("Timeout waiting for response", e);
        }
        catch (MailException e) {
            if (e instanceof ParseException) {
                this.connection.close();
            }
            throw this.failed("Error in response", e);
        }
        catch (IOException e) {
            this.connection.close();
            throw e;
        }
    }

    public ImapResponse sendCheckStatus() throws IOException {
        ImapResponse res = this.send();
        this.checkStatus(res);
        return res;
    }

    public void checkStatus(ImapResponse res) throws IOException {
        if (!res.isTagged()) {
            throw new MailException("Expected a tagged response");
        }
        if (!this.tag.equalsIgnoreCase(res.getTag())) {
            throw new MailException("Unexpected tag in response(expected " + this.tag + " but got " + res.getTag() + ")");
        }
        if (!res.isOK()) {
            throw this.failed(res.getResponseText().getText());
        }
    }

    public void write(ImapOutputStream out) throws IOException {
        out.write(this.tag);
        out.write(32);
        out.write(this.cmd.getName());
        if (this.params != null && this.params.size() > 0) {
            out.write(32);
            if (this.cmd.getCAtom() == CAtom.LOGIN && this.params.size() > 1) {
                this.writeData(out, this.params.get(0));
                out.write(32);
                this.writeUntracedList(out, this.params.subList(1, this.params.size()), "<password>");
            } else {
                this.writeList(out, this.params);
            }
        }
        out.newLine();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUntracedList(ImapOutputStream out, List<Object> data, String msg) throws IOException {
        TraceOutputStream os = this.connection.getTraceOutputStream();
        if (os != null && os.suspendTrace(msg)) {
            try {
                this.writeList(out, data);
                Object var6_5 = null;
                os.resumeTrace();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                os.resumeTrace();
                throw throwable;
            }
        } else {
            this.writeList(out, data);
        }
    }

    private void writeData(ImapOutputStream out, Object data) throws IOException {
        if (data instanceof String) {
            String s = (String)data;
            out.write(s.length() > 0 ? s : "\"\"");
        } else if (data instanceof Atom) {
            ((Atom)data).write(out);
        } else if (data instanceof Quoted) {
            ((Quoted)data).write(out);
        } else if (data instanceof Literal) {
            this.connection.writeLiteral((Literal)data);
        } else if (data instanceof Flags) {
            ((Flags)data).write(out);
        } else if (data instanceof MailboxName) {
            String encoded = ((MailboxName)data).encode();
            this.writeData(out, ImapData.asAString(encoded));
        } else if (data instanceof IDInfo) {
            this.writeData(out, ((IDInfo)data).toRequestParam());
        } else if (data instanceof Date) {
            this.writeData(out, new Quoted(ImapRequest.toInternalDate((Date)data)));
        } else if (data instanceof Object[]) {
            this.writeData(out, Arrays.asList((Object[])data));
        } else if (data instanceof List) {
            out.write(40);
            this.writeList(out, (List)data);
            out.write(41);
        } else if (data instanceof AppendMessage) {
            this.writeList(out, ((AppendMessage)data).getData());
        } else {
            this.writeData(out, data.toString());
        }
    }

    private static String toInternalDate(Date date) {
        return DateUtil.toImapDateTime(date);
    }

    private void writeList(ImapOutputStream out, List list) throws IOException {
        Iterator it = list.iterator();
        if (it.hasNext()) {
            this.writeData(out, it.next());
            while (it.hasNext()) {
                out.write(32);
                this.writeData(out, it.next());
            }
        }
    }

    public CommandFailedException failed(String error) {
        return this.failed(error, null);
    }

    public CommandFailedException failed(String error, Throwable cause) {
        CommandFailedException cfe = new CommandFailedException(this.cmd.getName(), error);
        try {
            cfe.setRequest(this.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        cfe.initCause(cause);
        return cfe;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tag).append(' ').append(this.cmd);
        if (this.params != null) {
            if (this.cmd.getCAtom() == CAtom.LOGIN && this.params.size() > 1) {
                sb.append(' ');
                this.append(sb, this.params.get(0));
                sb.append(" <password>");
            } else {
                for (Object param : this.params) {
                    sb.append(' ');
                    this.append(sb, param);
                }
            }
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, Object param) {
        if (param instanceof String) {
            String s = (String)param;
            sb.append(s.length() > 0 ? s : "\"\"");
        } else if (param instanceof Quoted) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((Quoted)param).write(baos);
            }
            catch (IOException e) {
                throw new AssertionError();
            }
            sb.append(baos.toString());
        } else if (param instanceof Literal) {
            sb.append("<literal ");
            sb.append(((Literal)param).getSize());
            sb.append(" bytes>");
        } else if (param instanceof MailboxName) {
            String encoded = ((MailboxName)param).encode();
            this.append(sb, ImapData.asAString(encoded));
        } else if (param instanceof IDInfo) {
            this.append(sb, ((IDInfo)param).toRequestParam());
        } else if (param instanceof Date) {
            this.append(sb, new Quoted(ImapRequest.toInternalDate((Date)param)));
        } else if (param instanceof Object[]) {
            this.append(sb, Arrays.asList((Object[])param));
        } else if (param instanceof List) {
            sb.append('(');
            Iterator it = ((List)param).iterator();
            if (it.hasNext()) {
                this.append(sb, it.next());
                while (it.hasNext()) {
                    sb.append(' ');
                    this.append(sb, it.next());
                }
            }
            sb.append(')');
        } else {
            sb.append(param.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        Date date = new Date();
        System.out.println("new = " + ImapRequest.toInternalDate(date));
    }
}

