/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.ParseException;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.Chars;
import com.zimbra.cs.mailclient.imap.DataHandler;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.Quoted;
import com.zimbra.cs.mailclient.util.Ascii;
import com.zimbra.cs.mailclient.util.Io;
import com.zimbra.cs.mailclient.util.LimitInputStream;
import com.zimbra.cs.mailclient.util.TraceInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ImapInputStream
extends MailInputStream {
    private final ImapConnection connection;
    private final ImapConfig config;
    private static final boolean DEBUG = false;

    public ImapInputStream(InputStream is, ImapConnection connection) {
        super(is);
        this.connection = connection;
        this.config = connection.getImapConfig();
    }

    public ImapInputStream(InputStream is, ImapConfig config) {
        super(is);
        this.connection = null;
        this.config = config;
    }

    public Atom readAtom() throws IOException {
        this.skipSpaces();
        String s = this.readChars(Chars.ATOM_CHARS);
        if (s.length() == 0) {
            throw new ParseException("Zero-length atom");
        }
        return new Atom(s);
    }

    public Atom readFlag() throws IOException {
        this.skipSpaces();
        this.sbuf.setLength(0);
        if (this.peek() == 92) {
            this.sbuf.append((char)this.read());
            if (this.peek() == 42) {
                this.sbuf.append((char)this.read());
                return new Atom(this.sbuf.toString());
            }
        }
        int len = this.sbuf.length();
        while (Chars.isAtomChar(this.peekChar())) {
            this.sbuf.append((char)this.read());
        }
        if (this.sbuf.length() - len == 0) {
            throw new ParseException("Invalid flag character '" + Ascii.pp((byte)this.peek()) + "'");
        }
        return new Atom(this.sbuf.toString());
    }

    public String readString() throws IOException {
        return this.readStringData().toString();
    }

    public ImapData readStringData() throws IOException {
        ImapData as = this.readAStringData();
        if (!as.isString()) {
            throw new ParseException("Expected STRING but got " + as);
        }
        return as;
    }

    public String readNString() throws IOException {
        ImapData ns = this.readNStringData();
        return ns.isNil() ? null : ns.toString();
    }

    public ImapData readNStringData() throws IOException {
        ImapData as = this.readAStringData();
        if (!as.isNString()) {
            throw new ParseException("Expected NIL or STRING, but got: " + as);
        }
        return as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Object readFetchData() throws IOException {
        DataHandler handler = this.getDataHandler();
        if (handler == null) {
            return this.readNStringData();
        }
        ImapData as = this.peek() == 123 ? this.readLiteral(false) : this.readNStringData();
        boolean st = as.isLiteral() && this.suspendTrace(as.getSize());
        try {
            Object object;
            try {
                object = handler.handleData(as);
                Object var6_6 = null;
                if (!as.isLiteral()) return object;
            }
            catch (Throwable e) {
                throw new MailException("Exception in data handler", e);
            }
            try {
                this.skipRemaining(as.getInputStream());
                Object var8_8 = null;
                if (!st) return object;
                this.resumeTrace();
                return object;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (!st) throw throwable;
                this.resumeTrace();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!as.isLiteral()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                if (!st) throw throwable2;
                this.resumeTrace();
                throw throwable2;
            }
            this.skipRemaining(as.getInputStream());
            Object var8_10 = null;
            if (!st) throw throwable;
            this.resumeTrace();
            throw throwable;
        }
    }

    private void skipRemaining(InputStream is) throws IOException {
        while (is.skip(8191L) > 0L) {
        }
    }

    private DataHandler getDataHandler() {
        return this.connection != null ? this.connection.getDataHandler() : null;
    }

    public String readAString() throws IOException {
        return this.readAStringData().toString();
    }

    public ImapData readAStringData() throws IOException {
        ImapData as;
        this.skipSpaces();
        switch (this.peekChar()) {
            case '\"': {
                as = this.readQuoted();
                break;
            }
            case '{': {
                as = this.readLiteral(true);
                break;
            }
            default: {
                String s = this.readChars(Chars.ASTRING_CHARS);
                if (s.length() == 0) {
                    throw new ParseException("Zero-length atom");
                }
                as = new Atom(s);
            }
        }
        return as;
    }

    public boolean isNumber() throws IOException {
        return !this.isEOF() && Chars.isNumber(this.peekChar());
    }

    public long readNZNumber() throws IOException {
        return this.readNumber(true);
    }

    public long readNumber() throws IOException {
        return this.readNumber(false);
    }

    private long readNumber(boolean nz) throws IOException {
        this.skipSpaces();
        String s = this.readChars(Chars.NUMBER_CHARS);
        if (s.length() == 0) {
            throw new ParseException("Zero-length number");
        }
        long n = Chars.getNumber(s);
        if (n == -1L) {
            throw new ParseException("Invalid number format: " + s);
        }
        if (nz && n == 0L) {
            throw new ParseException("Expected non-zero number but got " + s);
        }
        return n;
    }

    public Quoted readQuoted() throws IOException {
        int c;
        this.skipChar('\"');
        this.sbuf.setLength(0);
        while ((c = this.read()) != 34) {
            switch (c) {
                case 10: 
                case 13: {
                    throw new ParseException("Unexpected end of line while reading QUOTED string");
                }
                case -1: {
                    throw new EOFException("Unexpected end of stream while reading QUOTED string");
                }
                case 92: {
                    c = this.readChar();
                }
            }
            this.sbuf.append((char)c);
        }
        return new Quoted(this.sbuf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Literal readLiteral(boolean cache) throws IOException {
        this.skipChar('{');
        long len = this.readNumber();
        if (len > Integer.MAX_VALUE) {
            throw new ParseException("Literal size too large: " + len);
        }
        this.skipSpaces();
        this.skipChar('}');
        this.skipCRLF();
        boolean st = cache && this.suspendTrace((int)len);
        try {
            Literal literal = this.readLiteral((int)len, cache);
            Object var7_5 = null;
            if (st) {
                this.resumeTrace();
            }
            return literal;
        }
        catch (Throwable throwable) {
            block4: {
                Object var7_6 = null;
                if (!st) break block4;
                this.resumeTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Literal readLiteral(int len, boolean cache) throws IOException {
        if (!cache) {
            return new Literal(new LimitInputStream(this.in, len), len);
        }
        if (len <= this.config.getMaxLiteralMemSize()) {
            byte[] b = new byte[len];
            Io.readFully(this.in, b);
            return new Literal(b);
        }
        File f = File.createTempFile("lit", null, this.config.getLiteralDataDir());
        f.deleteOnExit();
        FileOutputStream os = new FileOutputStream(f);
        try {
            Io.copyBytes(this.in, os, len);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ((OutputStream)os).close();
            throw throwable;
        }
        ((OutputStream)os).close();
        return new Literal(f, true);
    }

    private boolean suspendTrace(int len) {
        TraceInputStream is;
        if (this.in instanceof TraceInputStream && (is = (TraceInputStream)this.in).isEnabled()) {
            int maxSize = this.config.getMaxLiteralTraceSize();
            return maxSize >= 0 && len > maxSize && is.suspendTrace("<<< literal data not shown >>>");
        }
        return false;
    }

    private void resumeTrace() {
        ((TraceInputStream)this.in).resumeTrace();
    }

    public String readText() throws IOException {
        return this.readChars(Chars.TEXT_CHARS);
    }

    public String readText(char delim) throws IOException {
        return this.readText(String.valueOf(delim));
    }

    public String readText(String delims) throws IOException {
        char c;
        this.sbuf.setLength(0);
        while (delims.indexOf(c = this.peekChar()) < 0) {
            if (!Chars.isTextChar(c)) {
                throw new ParseException("Unexpected character '" + Ascii.pp((byte)c) + "' while reading TEXT string");
            }
            this.sbuf.append((char)this.read());
        }
        if (this.sbuf.length() == 0) {
            throw new ParseException("Invalid text character '" + Ascii.pp((byte)c) + "'");
        }
        return this.sbuf.toString();
    }

    public String readChars(boolean[] chars) throws IOException {
        this.sbuf.setLength(0);
        while (chars[this.peekChar()]) {
            this.sbuf.append((char)this.read());
        }
        return this.sbuf.toString();
    }

    public void skipChar(char expectedChar) throws IOException {
        char c = this.readChar();
        if (c != expectedChar) {
            throw new ParseException("Unexpected character '" + Ascii.pp((byte)c) + "' (expecting '" + Ascii.pp((byte)expectedChar) + "')");
        }
    }

    public void skipNil() throws IOException {
        Atom atom = this.readAtom();
        if (!atom.isNil()) {
            throw new ParseException("Expecting NIL but got " + atom);
        }
    }

    public void skipCRLF() throws IOException {
        this.skipSpaces();
        this.skipChar('\r');
        this.skipChar('\n');
    }

    public boolean match(char c) throws IOException {
        if (this.peek() == c) {
            this.read();
            return true;
        }
        return false;
    }

    public void skipSpaces() throws IOException {
        while (this.match(' ')) {
        }
    }

    public boolean isEOL() throws IOException {
        return this.peek() == 13;
    }

    private static void pd(String fmt, Object ... args) {
        System.out.print("[DEBUG] ");
        System.out.printf(fmt, args);
        System.out.println();
    }
}

