/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.Chars;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.Quoted;
import com.zimbra.cs.mailclient.util.Ascii;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImapData {
    public static ImapData asAString(String s) {
        if (s.length() > 64) {
            return new Literal(Ascii.getBytes(s));
        }
        switch (ImapData.getType(s)) {
            case ATOM: {
                return new Atom(s);
            }
            case QUOTED: {
                return new Quoted(s);
            }
            case LITERAL: {
                return new Literal(ImapData.encodeUtf8(s));
            }
        }
        return null;
    }

    public static ImapData asNString(String s) {
        return s != null ? ImapData.asString(s) : Atom.NIL;
    }

    public static ImapData asString(String s) {
        return s.length() <= 64 && Chars.isText(s) ? new Quoted(s) : new Literal(ImapData.encodeUtf8(s));
    }

    private static Type getType(String s) {
        if (s.length() == 0) {
            return Type.QUOTED;
        }
        Type type = Type.ATOM;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Chars.isTextChar(c)) {
                return Type.LITERAL;
            }
            if (Chars.isAStringChar(c)) continue;
            type = Type.QUOTED;
        }
        return type;
    }

    private static byte[] encodeUtf8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("UTF-8 charset not found");
        }
    }

    public static String asSequenceSet(List<? extends Number> ids) {
        StringBuilder sb = new StringBuilder();
        if (ids.isEmpty()) {
            return null;
        }
        Iterator<? extends Number> it = ids.iterator();
        sb.append(it.next().longValue());
        while (it.hasNext()) {
            sb.append(',').append(it.next().longValue());
        }
        return sb.toString();
    }

    public abstract Type getType();

    public boolean isAtom() {
        return this.getType() == Type.ATOM;
    }

    public boolean isQuoted() {
        return this.getType() == Type.QUOTED;
    }

    public boolean isLiteral() {
        return this.getType() == Type.LITERAL;
    }

    public boolean isString() {
        return this.isQuoted() || this.isLiteral();
    }

    public boolean isAString() {
        return this.isAtom() || this.isString();
    }

    public boolean isNString() {
        return this.isNil() || this.isString();
    }

    public boolean isNil() {
        return this.equals(Atom.NIL);
    }

    public abstract int getSize();

    public abstract byte[] getBytes() throws IOException;

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    public void dispose() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ATOM,
        QUOTED,
        LITERAL;

    }
}

