/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.mailclient.imap;

import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.MailConnection;
import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.MailOutputStream;
import com.zimbra.cs.mailclient.imap.AppendMessage;
import com.zimbra.cs.mailclient.imap.AppendResult;
import com.zimbra.cs.mailclient.imap.Atom;
import com.zimbra.cs.mailclient.imap.BasicResponseHandler;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.CopyResult;
import com.zimbra.cs.mailclient.imap.DataHandler;
import com.zimbra.cs.mailclient.imap.FetchResponseHandler;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.IDInfo;
import com.zimbra.cs.mailclient.imap.ImapCapabilities;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapInputStream;
import com.zimbra.cs.mailclient.imap.ImapOutputStream;
import com.zimbra.cs.mailclient.imap.ImapRequest;
import com.zimbra.cs.mailclient.imap.ImapResponse;
import com.zimbra.cs.mailclient.imap.ListData;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.Mailbox;
import com.zimbra.cs.mailclient.imap.MailboxName;
import com.zimbra.cs.mailclient.imap.MessageData;
import com.zimbra.cs.mailclient.imap.ResponseHandler;
import com.zimbra.cs.mailclient.imap.ResponseText;
import com.zimbra.cs.mailclient.util.Ascii;
import com.zimbra.cs.mailclient.util.TraceOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImapConnection
extends MailConnection {
    private ImapCapabilities capabilities;
    private Mailbox mailbox;
    private ImapRequest request;
    private DataHandler dataHandler;
    private final AtomicInteger tagCount = new AtomicInteger();
    private static final Logger LOGGER = Logger.getLogger(ImapConnection.class);
    private static final String TAG_FORMAT = "C%02d";

    public ImapConnection(ImapConfig config) {
        super(config);
    }

    public void setDataHandler(DataHandler handler) {
        this.dataHandler = handler;
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    @Override
    protected MailInputStream newMailInputStream(InputStream is) {
        return new ImapInputStream(is, this);
    }

    @Override
    protected MailOutputStream newMailOutputStream(OutputStream os) {
        return new ImapOutputStream(os);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void processGreeting() throws IOException {
        ImapResponse res = this.readResponse();
        if (res.isUntagged()) {
            this.greeting = res.getResponseText().getText();
            switch (res.getCCode()) {
                case BYE: {
                    throw new MailException(this.greeting);
                }
                case PREAUTH: 
                case OK: {
                    this.setState(res.isOK() ? MailConnection.State.NOT_AUTHENTICATED : MailConnection.State.AUTHENTICATED);
                    ResponseText rt = res.getResponseText();
                    if (CAtom.CAPABILITY.atom().equals(rt.getCode())) {
                        this.capabilities = (ImapCapabilities)rt.getData();
                    } else {
                        this.capability();
                    }
                    return;
                }
            }
        }
        throw new MailException("Expected server greeting but got: " + res);
    }

    @Override
    protected void sendLogin(String user, String pass) throws IOException {
        this.newRequest(CAtom.LOGIN, ImapData.asAString(user), ImapData.asAString(pass)).sendCheckStatus();
    }

    @Override
    public synchronized void logout() throws IOException {
        if (this.isShutdown()) {
            return;
        }
        if (this.request != null) {
            throw new IllegalStateException("Request pending");
        }
        this.setState(MailConnection.State.LOGOUT);
        try {
            this.newRequest(CAtom.LOGOUT, new Object[0]).sendCheckStatus();
        }
        catch (CommandFailedException e) {
            this.getLogger().warn((Object)"Logout failed, force closing connection", (Throwable)e);
            this.close();
        }
    }

    @Override
    protected void sendAuthenticate(boolean ir) throws IOException {
        ImapRequest req = this.newRequest(CAtom.AUTHENTICATE, this.authenticator.getMechanism());
        if (ir) {
            byte[] response = this.authenticator.getInitialResponse();
            req.addParam(Ascii.toString(Base64.encodeBase64((byte[])response)));
        }
        req.sendCheckStatus();
    }

    @Override
    protected void sendStartTls() throws IOException {
        this.newRequest(CAtom.STARTTLS, new Object[0]).sendCheckStatus();
    }

    public ImapCapabilities capability() throws IOException {
        this.newRequest(CAtom.CAPABILITY, new Object[0]).sendCheckStatus();
        return this.capabilities;
    }

    public void noop() throws IOException {
        this.newRequest(CAtom.NOOP, new Object[0]).sendCheckStatus();
    }

    public void noop(ResponseHandler handler) throws IOException {
        ImapRequest req = this.newRequest(CAtom.NOOP, new Object[0]);
        req.setResponseHandler(handler);
        req.sendCheckStatus();
    }

    public void idle(ResponseHandler handler) throws IOException {
        ImapRequest req = this.newRequest(CAtom.IDLE, new Object[0]);
        req.setResponseHandler(handler);
        ImapResponse res = req.send();
        if (res != null) {
            if (res.isOK()) {
                throw new MailException("Expected IDLE continuation but got final response");
            }
            req.checkStatus(res);
        }
    }

    public void check() throws IOException {
        this.newRequest(CAtom.CHECK, new Object[0]).sendCheckStatus();
    }

    public void xatom(String cmd, Object ... params) throws IOException {
        this.newRequest(cmd, params).sendCheckStatus();
    }

    public IDInfo id() throws IOException {
        return this.id(null);
    }

    public IDInfo id(IDInfo info) throws IOException {
        ImapRequest req = this.newRequest(CAtom.ID, info != null ? info : Atom.NIL);
        ArrayList results = new ArrayList(1);
        req.setResponseHandler(new BasicResponseHandler(CAtom.ID, results));
        req.sendCheckStatus();
        return results.isEmpty() ? null : (IDInfo)results.get(0);
    }

    public synchronized boolean isSelected(String name) {
        return this.mailbox != null && this.mailbox.getName().equals(name);
    }

    public synchronized Mailbox select(String name) throws IOException {
        this.mailbox = this.doSelectOrExamine(CAtom.SELECT, name);
        this.setState(MailConnection.State.SELECTED);
        return this.getMailbox();
    }

    public Mailbox examine(String name) throws IOException {
        return this.doSelectOrExamine(CAtom.EXAMINE, name);
    }

    private Mailbox doSelectOrExamine(CAtom cmd, String name) throws IOException {
        Mailbox mbox = new Mailbox(name);
        ImapRequest req = this.newRequest(cmd, new MailboxName(name));
        req.setResponseHandler(mbox);
        mbox.handleResponse(req.sendCheckStatus());
        return mbox;
    }

    public void create(String name) throws IOException {
        this.newRequest(CAtom.CREATE, new MailboxName(name)).sendCheckStatus();
    }

    public void delete(String name) throws IOException {
        this.newRequest(CAtom.DELETE, new MailboxName(name)).sendCheckStatus();
    }

    public void rename(String from, String to) throws IOException {
        this.newRequest(CAtom.RENAME, new MailboxName(from), new MailboxName(to)).sendCheckStatus();
    }

    public void subscribe(String name) throws IOException {
        this.newRequest(CAtom.SUBSCRIBE, new MailboxName(name)).sendCheckStatus();
    }

    public void unsubscribe(String name) throws IOException {
        this.newRequest(CAtom.UNSUBSCRIBE, new MailboxName(name)).sendCheckStatus();
    }

    public AppendResult append(String mbox, Flags flags, Date date, Literal data) throws IOException {
        return this.append(mbox, new AppendMessage(flags, date, data));
    }

    public AppendResult append(String mbox, AppendMessage ... msgs) throws IOException {
        return this.append(mbox, Arrays.asList(msgs));
    }

    public AppendResult append(String mbox, Collection<AppendMessage> msgs) throws IOException {
        ImapRequest req = this.newRequest(CAtom.APPEND, new MailboxName(mbox));
        for (AppendMessage msg : msgs) {
            req.addParam(msg);
        }
        ImapResponse res = req.sendCheckStatus();
        ResponseText rt = res.getResponseText();
        return rt.getCCode() == CAtom.APPENDUID ? (AppendResult)rt.getData() : null;
    }

    public void expunge() throws IOException {
        this.newRequest(CAtom.EXPUNGE, new Object[0]).sendCheckStatus();
    }

    public void uidExpunge(String seq) throws IOException {
        this.newUidRequest(CAtom.EXPUNGE, seq).sendCheckStatus();
    }

    public synchronized void mclose() throws IOException {
        this.newRequest(CAtom.CLOSE, new Object[0]).sendCheckStatus();
        this.mailbox = null;
        this.setState(MailConnection.State.AUTHENTICATED);
    }

    public Mailbox status(String name, Object ... params) throws IOException {
        ImapRequest req = this.newRequest(CAtom.STATUS, new MailboxName(name), params);
        ArrayList results = new ArrayList(1);
        req.setResponseHandler(new BasicResponseHandler(CAtom.STATUS, results));
        req.sendCheckStatus();
        if (results.isEmpty()) {
            throw new MailException("Missing STATUS response data");
        }
        ((Mailbox)results.get(0)).setName(name);
        return (Mailbox)results.get(0);
    }

    public List<ListData> list(String ref, String mbox) throws IOException {
        return this.doList(CAtom.LIST, ref, mbox);
    }

    public List<ListData> lsub(String ref, String mbox) throws IOException {
        return this.doList(CAtom.LSUB, ref, mbox);
    }

    public boolean exists(String mbox) throws IOException {
        return !this.list("", mbox).isEmpty();
    }

    private List<ListData> doList(CAtom cmd, String ref, String mbox) throws IOException {
        ImapRequest req = this.newRequest(cmd, new MailboxName(ref), new MailboxName(mbox));
        ArrayList<ListData> results = new ArrayList<ListData>();
        req.setResponseHandler(new BasicResponseHandler(CAtom.LIST.atom(), results));
        req.sendCheckStatus();
        return results;
    }

    public char getDelimiter() throws IOException {
        List<ListData> ld = this.list("", "");
        return ld.isEmpty() ? (char)'\u0000' : ld.get(0).getDelimiter();
    }

    public CopyResult copy(String seq, String mbox) throws IOException {
        ImapRequest req = this.newRequest(CAtom.COPY, seq, new MailboxName(mbox));
        ResponseText rt = req.sendCheckStatus().getResponseText();
        return rt.getCCode() == CAtom.COPYUID ? (CopyResult)rt.getData() : null;
    }

    public CopyResult uidCopy(String seq, String mbox) throws IOException {
        ImapRequest req = this.newUidRequest(CAtom.COPY, seq, new MailboxName(mbox));
        ResponseText rt = req.sendCheckStatus().getResponseText();
        return rt.getCCode() == CAtom.COPYUID ? (CopyResult)rt.getData() : null;
    }

    public void fetch(String seq, Object param, ResponseHandler handler) throws IOException {
        this.fetch(CAtom.FETCH.name(), seq, param, handler);
    }

    public void uidFetch(String seq, Object param, ResponseHandler handler) throws IOException {
        ImapRequest req = this.newUidRequest(CAtom.FETCH, seq, param);
        req.setResponseHandler(handler);
        req.sendCheckStatus();
    }

    private void fetch(String cmd, String seq, Object param, ResponseHandler handler) throws IOException {
        ImapRequest req = this.newRequest(cmd, seq, param);
        req.setResponseHandler(handler);
        req.sendCheckStatus();
    }

    public List<Long> getUids(String seq) throws IOException {
        final ArrayList<Long> uids = new ArrayList<Long>();
        this.uidFetch(seq, "UID", new FetchResponseHandler(){

            public void handleFetchResponse(MessageData md) {
                uids.add(md.getUid());
            }
        });
        return uids;
    }

    public Map<Long, MessageData> fetch(String seq, Object param) throws IOException {
        final HashMap<Long, MessageData> results = new HashMap<Long, MessageData>();
        this.fetch(seq, param, new FetchResponseHandler(false){

            public void handleFetchResponse(MessageData md) {
                long msgno = md.getMsgno();
                if (msgno > 0L) {
                    MessageData omd = (MessageData)results.get(msgno);
                    if (omd != null) {
                        omd.addFields(md);
                    } else {
                        results.put(msgno, md);
                    }
                }
            }
        });
        return results;
    }

    public MessageData fetch(long msgno, Object param) throws IOException {
        return this.fetch(String.valueOf(msgno), param).get(msgno);
    }

    public Map<Long, MessageData> uidFetch(String seq, Object param) throws IOException {
        final HashMap<Long, MessageData> results = new HashMap<Long, MessageData>();
        this.uidFetch(seq, param, new FetchResponseHandler(false){

            public void handleFetchResponse(MessageData md) {
                long uid = md.getUid();
                if (uid > 0L) {
                    MessageData omd = (MessageData)results.get(uid);
                    if (omd != null) {
                        omd.addFields(md);
                    } else {
                        results.put(uid, md);
                    }
                }
            }
        });
        return results;
    }

    public MessageData uidFetch(long uid, Object param) throws IOException {
        return this.uidFetch(String.valueOf(uid), param).get(uid);
    }

    public List<Long> search(Object ... params) throws IOException {
        return this.doSearch(CAtom.SEARCH.name(), params);
    }

    public List<Long> uidSearch(Object ... params) throws IOException {
        return this.doSearch("UID SEARCH", params);
    }

    private List<Long> doSearch(String cmd, Object ... params) throws IOException {
        final ArrayList<Long> results = new ArrayList<Long>();
        ImapRequest req = this.newRequest(cmd, params);
        req.setResponseHandler(new ResponseHandler(){

            public void handleResponse(ImapResponse res) {
                if (res.getCCode() == CAtom.SEARCH) {
                    results.addAll((List)res.getData());
                }
            }
        });
        req.sendCheckStatus();
        return results;
    }

    public void store(String seq, String item, Object flags) throws IOException {
        this.store(seq, item, flags, null);
    }

    public void store(String seq, String item, Object flags, ResponseHandler handler) throws IOException {
        ImapRequest req = this.newRequest(CAtom.STORE, seq, item, flags);
        req.setResponseHandler(handler);
        req.sendCheckStatus();
    }

    public void uidStore(String seq, String item, Object flags) throws IOException {
        this.uidStore(seq, item, flags, null);
    }

    public void uidStore(String seq, String item, Object flags, ResponseHandler handler) throws IOException {
        ImapRequest req = this.newUidRequest(CAtom.STORE, seq, item, flags);
        req.setResponseHandler(handler);
        req.sendCheckStatus();
    }

    public ImapRequest newRequest(CAtom cmd, Object ... params) {
        return new ImapRequest(this, cmd.atom(), params);
    }

    public ImapRequest newRequest(Atom cmd, Object ... params) {
        return new ImapRequest(this, cmd, params);
    }

    public ImapRequest newRequest(String cmd, Object ... params) {
        return new ImapRequest(this, new Atom(cmd), params);
    }

    public ImapRequest newUidRequest(CAtom cmd, Object ... params) {
        return this.newRequest("UID " + cmd.toString(), params);
    }

    public ImapCapabilities getCapabilities() {
        return this.capabilities;
    }

    public Mailbox getMailbox() {
        return this.mailbox != null ? new Mailbox(this.mailbox) : null;
    }

    public TraceOutputStream getTraceOutputStream() {
        return this.traceOut;
    }

    public boolean hasCapability(String cap) {
        return this.capabilities != null && this.capabilities.hasCapability(cap);
    }

    public boolean hasMechanism(String method) {
        return this.hasCapability("AUTH=" + method);
    }

    public boolean hasUidPlus() {
        return this.hasCapability("UIDPLUS");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized ImapResponse sendRequest(ImapRequest req) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection is closed");
        }
        if (this.request != null) {
            throw new IllegalStateException("Request already pending");
        }
        if (req.isIdle()) {
            return this.sendIdle(req);
        }
        this.request = req;
        try {
            try {
                req.write(this.getImapOutputStream());
            }
            catch (LiteralException e) {
                ImapResponse imapResponse = e.res;
                Object var5_6 = null;
                this.request = null;
                return imapResponse;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.request = null;
            throw throwable;
        }
        while (true) {
            ImapResponse res;
            if ((res = this.waitForResponse()).isTagged()) {
                ImapResponse imapResponse = res;
                Object var5_7 = null;
                this.request = null;
                return imapResponse;
            }
            assert (res.isContinuation());
            if (!req.isAuthenticate()) {
                throw req.failed("Unexpected continuation response");
            }
            this.processContinuation(res.getResponseText().getText());
        }
    }

    public synchronized boolean isIdling() {
        return this.request != null && this.request.isIdle();
    }

    private ImapResponse sendIdle(ImapRequest req) throws IOException {
        this.request = req;
        try {
            req.write(this.getImapOutputStream());
            ImapResponse res = this.waitForResponse();
            if (res.isTagged()) {
                return res;
            }
            assert (res.isContinuation());
            Thread t = new Thread(new Runnable(){

                public void run() {
                    ImapConnection.this.idleHandler();
                }
            });
            t.setName("IMAP IDLE thread");
            t.setDaemon(true);
            t.start();
        }
        catch (IOException e) {
            this.request = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idleHandler() {
        try {
            ImapResponse res = this.waitForResponse();
            if (res.isContinuation()) {
                throw new IOException("Unexpected continuation response");
            }
            assert (res.isTagged());
        }
        catch (IOException e) {
            this.getLogger().error((Object)"IDLE failed", (Throwable)e);
        }
        ImapConnection imapConnection = this;
        synchronized (imapConnection) {
            this.request = null;
            this.notifyAll();
        }
    }

    public synchronized void stopIdle() throws IOException {
        if (this.isIdling()) {
            ImapOutputStream out = this.getImapOutputStream();
            out.writeLine("DONE");
            out.flush();
            while (this.isIdling()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private ImapOutputStream getImapOutputStream() {
        return (ImapOutputStream)this.mailOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeLiteral(Literal lit) throws IOException {
        boolean lp = this.getImapConfig().isUseLiteralPlus() && this.hasCapability("LITERAL+");
        ImapOutputStream out = (ImapOutputStream)this.mailOut;
        lit.writePrefix(out, lp);
        if (!lp) {
            out.flush();
            ImapResponse res = this.waitForResponse();
            if (!res.isContinuation()) {
                assert (res.isTagged());
                throw new LiteralException(res);
            }
        }
        if (this.traceOut != null && this.traceOut.isEnabled()) {
            int size = lit.getSize();
            int maxSize = this.getImapConfig().getMaxLiteralTraceSize();
            if (maxSize >= 0 && size > maxSize) {
                String msg = String.format("<literal %d bytes>", size);
                this.traceOut.suspendTrace(msg);
                try {
                    lit.writeData(out);
                    Object var8_8 = null;
                    this.traceOut.resumeTrace();
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.traceOut.resumeTrace();
                    throw throwable;
                }
                return;
            }
        }
        lit.writeData(out);
    }

    public ImapConfig getImapConfig() {
        return (ImapConfig)this.config;
    }

    private boolean isShutdown() {
        return this.isClosed() || this.isLogout();
    }

    private ImapResponse waitForResponse() throws IOException {
        ImapResponse res;
        while (this.processResponse(res = this.readResponse())) {
        }
        return res;
    }

    private ImapResponse readResponse() throws IOException {
        return ImapResponse.read((ImapInputStream)this.mailIn);
    }

    private synchronized boolean processResponse(ImapResponse res) throws IOException {
        if (res.isUntagged() && res.isBAD()) {
            this.getLogger().error((Object)("Untagged BAD response: " + res));
            return true;
        }
        if (res.isContinuation() || res.isUntagged() && res.isBAD()) {
            return false;
        }
        if (res.isUntagged()) {
            this.processUntagged(res);
            res.dispose();
        }
        if (res.isOK()) {
            ResponseText rt = res.getResponseText();
            Atom code = rt.getCode();
            if (code != null && code.getCAtom() == CAtom.CAPABILITY) {
                this.capabilities = (ImapCapabilities)rt.getData();
            }
        } else if (res.getCCode() == CAtom.CAPABILITY) {
            this.capabilities = (ImapCapabilities)res.getData();
        } else if (this.mailbox != null && !this.request.isSelectOrExamine()) {
            this.mailbox.handleResponse(res);
        }
        return res.isUntagged();
    }

    private boolean processUntagged(ImapResponse res) throws IOException {
        ResponseHandler handler = this.request.getResponseHandler();
        if (handler != null) {
            try {
                handler.handleResponse(res);
            }
            catch (Throwable e) {
                throw new MailException("Exception in response handler", e);
            }
        }
        return false;
    }

    public String newTag() {
        Formatter fmt = new Formatter();
        fmt.format(TAG_FORMAT, this.tagCount.incrementAndGet());
        return fmt.toString();
    }

    private static class LiteralException
    extends IOException {
        final ImapResponse res;

        LiteralException(ImapResponse res) {
            this.res = res;
        }
    }
}

